package ph.com.nightowlstudios.entity.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;

import java.io.IOException;
import java.time.LocalDate;

/**
 * @author <a href="mailto:josephharveyangeles@gmail.com">Joseph Harvey Angeles - <i>yev</i></a>
 * @since 8/11/21
 **/
public class LocalDateSerializer extends StdSerializer<LocalDate> {

    protected LocalDateSerializer() { this(LocalDate.class); }

    protected LocalDateSerializer(Class<LocalDate> t) { super(t); }

    @Override
    public void serialize(LocalDate value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        long epoch = value.toEpochDay();
        gen.writeString(Long.toString(epoch));
    }
}
