/*
 * Decompiled with CFR 0.152.
 */
package ph.com.nightowlstudios.entity.serializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.time.LocalDate;

public class LocalDateDeserializer
extends StdDeserializer<LocalDate> {
    protected LocalDateDeserializer() {
        this(LocalDate.class);
    }

    protected LocalDateDeserializer(Class<?> vc) {
        super(vc);
    }

    public LocalDate deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        try {
            long epoch = Long.parseLong(p.getText());
            return LocalDate.ofEpochDay(epoch);
        }
        catch (NumberFormatException e) {
            return LocalDate.parse(p.getText());
        }
    }
}

