/*
 * Decompiled with CFR 0.152.
 */
package ph.com.nightowlstudios.utils;

import io.vavr.CheckedFunction0;
import io.vavr.control.Try;
import io.vertx.core.json.Json;
import io.vertx.core.json.JsonObject;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import ph.com.nightowlstudios.entity.Entity;

public final class Utils {
    private static final String UNDERSCORE = "_";

    private Utils() {
    }

    public static <T> Optional<T> getFirstElement(List<T> list) {
        return list.isEmpty() ? Optional.empty() : Optional.ofNullable(list.get(0));
    }

    public static <T extends Entity> T merge(T from, T to) {
        Entity result = (Entity)Json.decodeValue((String)new JsonObject().encode(), from.getClass());
        for (Field field : result.getClass().getDeclaredFields()) {
            String prefix = field.getType().equals(Boolean.TYPE) ? "is" : "get";
            Supplier<Object> toValue = () -> Try.of((CheckedFunction0 & Serializable)() -> to.getClass().getDeclaredMethod(prefix + StringUtils.capitalize((String)field.getName()), new Class[0]).invoke((Object)to, new Object[0])).getOrNull();
            Supplier<Object> fromValue = () -> Try.of((CheckedFunction0 & Serializable)() -> from.getClass().getDeclaredMethod(prefix + StringUtils.capitalize((String)field.getName()), new Class[0]).invoke((Object)from, new Object[0])).getOrNull();
            if (toValue.get() == null) {
                Try.of((CheckedFunction0 & Serializable)() -> result.getClass().getDeclaredMethod("set" + StringUtils.capitalize((String)field.getName()), field.getType()).invoke((Object)result, fromValue.get()));
                continue;
            }
            Try.of((CheckedFunction0 & Serializable)() -> result.getClass().getDeclaredMethod("set" + StringUtils.capitalize((String)field.getName()), field.getType()).invoke((Object)result, toValue.get()));
        }
        return (T)result;
    }

    public static JsonObject camelCaseKeys(JsonObject json) {
        ((Stream)json.stream().parallel()).filter(e -> ((String)e.getKey()).contains(UNDERSCORE)).forEach(e -> {
            json.put(Utils.toCamelCase((String)e.getKey()), e.getValue());
            json.remove((String)e.getKey());
        });
        return json;
    }

    public static String toCamelCase(String word) {
        return Utils.toCamelCase(word, UNDERSCORE);
    }

    public static String toCamelCase(String word, String separator) {
        if (StringUtils.isBlank((CharSequence)word)) {
            return "";
        }
        String[] tokens = word.split(separator);
        if (tokens.length == 1) {
            return tokens[0].trim().toLowerCase();
        }
        String head = tokens[0];
        String[] tail = Arrays.copyOfRange(tokens, 1, tokens.length);
        return head.toLowerCase() + ((Stream)Arrays.stream(tail).sequential()).map(StringUtils::capitalize).collect(Collectors.joining());
    }
}

