/*
 * Decompiled with CFR 0.152.
 */
package ph.com.nightowlstudios.persistence;

import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.pgclient.PgConnectOptions;
import io.vertx.pgclient.PgPool;
import io.vertx.sqlclient.Pool;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.RowSet;
import io.vertx.sqlclient.SqlResult;
import java.util.stream.Collector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ph.com.nightowlstudios.persistence.query.Query;

public class PersistenceClient {
    private static final Logger log = LoggerFactory.getLogger(PersistenceClient.class);
    private final Pool pool;

    public PersistenceClient() {
        this(Vertx.currentContext().owner(), Vertx.currentContext().config().getJsonObject("db"));
    }

    public PersistenceClient(Vertx vertx, JsonObject dbConf) {
        PgConnectOptions connectOptions = new PgConnectOptions().setDatabase(dbConf.getString("name")).setPort(dbConf.getInteger("port").intValue()).setHost(dbConf.getString("host")).setUser(dbConf.getString("user")).setPassword(dbConf.getString("password"));
        PoolOptions poolOptions = new PoolOptions().setMaxSize(dbConf.getInteger("maxPoolSize").intValue());
        this.pool = PgPool.pool((Vertx)vertx, (PgConnectOptions)connectOptions, (PoolOptions)poolOptions);
    }

    protected Pool pool() {
        return this.pool;
    }

    public <T> Future<T> query(Query q, Collector<Row, ?, T> collector) {
        Promise promise = Promise.promise();
        log.debug("Executing SQL: {}", (Object)q.sql());
        log.debug("Against Tuples: {}", (Object)q.tuple().deepToString());
        this.pool().preparedQuery(q.sql()).collecting(collector).execute(q.tuple(), ar -> {
            if (ar.failed()) {
                log.error("SQL query FAIL: {}", (Object)ar.cause().getMessage());
                promise.fail(ar.cause());
                return;
            }
            promise.complete(((SqlResult)ar.result()).value());
        });
        return promise.future();
    }

    public Future<RowSet<Row>> query(Query q) {
        Promise promise = Promise.promise();
        log.debug("Executing SQL: {}", (Object)q.sql());
        log.debug("Against Tuples: {}", (Object)q.tuple().deepToString());
        this.pool().preparedQuery(q.sql()).execute(q.tuple(), ar -> {
            if (ar.failed()) {
                log.error("SQL query FAIL: {}", (Object)ar.cause().getMessage());
                promise.fail(ar.cause());
                return;
            }
            promise.complete(ar.result());
        });
        return promise.future();
    }

    public <T> Future<T> query(String sql, Collector<Row, ?, T> collector) {
        Promise promise = Promise.promise();
        log.debug("Executing plain SQL: {}", (Object)sql);
        this.pool().query(sql).collecting(collector).execute(ar -> {
            if (ar.failed()) {
                log.error("SQL query FAIL: {}", (Object)ar.cause().getMessage());
                promise.fail(ar.cause());
                return;
            }
            promise.complete(((SqlResult)ar.result()).value());
        });
        return promise.future();
    }

    public Future<Void> query(String sql) {
        Promise promise = Promise.promise();
        log.debug("Executing plain SQL: {}", (Object)sql);
        this.pool().query(sql).execute(ar -> {
            if (ar.failed()) {
                log.error("SQL query FAIL: {}", (Object)ar.cause().getMessage());
                promise.fail(ar.cause());
                return;
            }
            promise.complete();
        });
        return promise.future();
    }
}

