/*
 * Decompiled with CFR 0.152.
 */
package ph.com.nightowlstudios.core;

import io.vertx.core.AbstractVerticle;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.JksOptions;
import io.vertx.core.net.PemKeyCertOptions;
import io.vertx.core.net.PfxOptions;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.BodyHandler;
import io.vertx.ext.web.handler.CorsHandler;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ph.com.nightowlstudios.resource.Resource;

class HttpServerVerticle
extends AbstractVerticle {
    private static final Logger log = LoggerFactory.getLogger(HttpServerVerticle.class);
    private final Supplier<Boolean> allowCORSCredentials;
    private final Supplier<Set<HttpMethod>> allowedMethods;
    private final Supplier<Set<String>> allowedHeaders;
    private final Supplier<Set<String>> exposedHeaders;
    private final Supplier<String> apiPrefix;
    private final Supplier<String> webSocketPrefix;
    private final Supplier<String> bannerText;
    private final Consumer<Router> onRouterCreated;
    private final Supplier<Handler<RoutingContext>> createRouteLogHandler;
    private final Supplier<Handler<RoutingContext>> createRouteFailHandler;
    private final Supplier<Class<Resource>[]> getResourceClasses;
    private final Consumer<Router> setupRoutes;
    private final Function<Vertx, Router> createWebSocketRouter;
    private final Consumer<HttpServer> onStart;
    private final Consumer<Throwable> onStartFail;

    HttpServerVerticle(Supplier<Boolean> allowCORSCredentials, Supplier<Set<HttpMethod>> allowedMethods, Supplier<Set<String>> allowedHeaders, Supplier<Set<String>> exposedHeaders, Supplier<String> apiPrefix, Consumer<Router> onRouterCreated, Supplier<Handler<RoutingContext>> createRouteLogHandler, Supplier<Handler<RoutingContext>> createRouteFailHandler, Supplier<Class<Resource>[]> getResourceClasses, Consumer<Router> setupRoutes, Supplier<String> webSocketRoute, Function<Vertx, Router> createWebSocketRouter, Supplier<String> bannerText, Consumer<HttpServer> onStart, Consumer<Throwable> onStartFail) {
        this.allowCORSCredentials = allowCORSCredentials;
        this.allowedMethods = allowedMethods;
        this.allowedHeaders = allowedHeaders;
        this.exposedHeaders = exposedHeaders;
        this.apiPrefix = apiPrefix;
        this.onRouterCreated = onRouterCreated;
        this.createRouteLogHandler = createRouteLogHandler;
        this.createRouteFailHandler = createRouteFailHandler;
        this.getResourceClasses = getResourceClasses;
        this.setupRoutes = setupRoutes;
        this.webSocketPrefix = webSocketRoute;
        this.createWebSocketRouter = createWebSocketRouter;
        this.bannerText = bannerText;
        this.onStart = onStart;
        this.onStartFail = onStartFail;
    }

    private String getAllowedOrigins() {
        return this.config().getString("allowedOrigins", "*");
    }

    protected int getPort() {
        return this.config().getInteger("port", Integer.valueOf(8888));
    }

    protected String appName() {
        return this.config().getString("name", "edge.api");
    }

    public void start(Promise<Void> startPromise) {
        Router rootRouter = Router.router((Vertx)this.vertx);
        rootRouter.route().handler((Handler)CorsHandler.create((String)this.getAllowedOrigins()).allowCredentials(this.allowCORSCredentials.get().booleanValue()).allowedMethods(this.allowedMethods.get()).allowedHeaders(this.allowedHeaders.get()).exposedHeaders(this.exposedHeaders.get()));
        rootRouter.route().handler((Handler)BodyHandler.create());
        this.onRouterCreated.accept(rootRouter);
        rootRouter.mountSubRouter(this.apiPrefix.get(), this.createApiRouter());
        rootRouter.mountSubRouter(this.webSocketPrefix.get(), this.createWebSocketRouter.apply(this.vertx));
        this.createHttpServer().requestHandler((Handler)rootRouter).listen(this.getPort(), http -> {
            if (http.succeeded()) {
                startPromise.complete();
                log.info(this.bannerText.get());
                log.info("{} online at PORT: {}", (Object)this.appName(), (Object)((HttpServer)http.result()).actualPort());
                this.onStart.accept((HttpServer)http.result());
                return;
            }
            log.error("Error running server: " + http.cause());
            startPromise.fail(http.cause());
            this.onStartFail.accept(http.cause());
        });
    }

    private Router createApiRouter() throws RuntimeException {
        Router router = Router.router((Vertx)this.vertx);
        router.route().handler(this.createRouteLogHandler.get());
        router.route().failureHandler(this.createRouteFailHandler.get());
        for (Class<Resource> controller : this.getResourceClasses.get()) {
            try {
                controller.getDeclaredConstructor(Router.class).newInstance(router);
            }
            catch (Exception e) {
                log.error("Unable to load {}. Error on {}. ", (Object)controller.getCanonicalName(), (Object)e.getMessage());
                e.printStackTrace();
            }
        }
        this.setupRoutes.accept(router);
        return router;
    }

    private HttpServer createHttpServer() {
        if (this.isProduction() && !this.sslConfig().isEmpty()) {
            return this.vertx.createHttpServer(this.createSSLHttpOptions());
        }
        return this.vertx.createHttpServer();
    }

    private HttpServerOptions createSSLHttpOptions() {
        JsonObject ssl = this.sslConfig();
        HttpServerOptions options = new HttpServerOptions().setUseAlpn(false).setSsl(true);
        switch (ssl.getString("type", "")) {
            case "jks": {
                options.setKeyStoreOptions(new JksOptions().setPath(ssl.getString("path")).setPassword(ssl.getString("password")));
                break;
            }
            case "pfx": {
                options.setPfxKeyCertOptions(new PfxOptions().setPath(ssl.getString("path")).setPassword(ssl.getString("password")));
                break;
            }
            case "pem": {
                options.setPemKeyCertOptions(new PemKeyCertOptions().setKeyPath(ssl.getString("keyPath")).setCertPath(ssl.getString("certPath")));
            }
            default: {
                log.error("Missing SSL Configuration");
                throw new RuntimeException("No SSL Configuration Provided");
            }
        }
        return options;
    }

    protected boolean isProduction() {
        Predicate<String> isProdEnv = value -> value.equalsIgnoreCase("prod") || value.equalsIgnoreCase("production");
        if (StringUtils.isEmpty((CharSequence)this.config().getString("env", ""))) {
            return isProdEnv.test(Optional.ofNullable(System.getenv("env")).orElse("prod"));
        }
        return isProdEnv.test(this.config().getString("env"));
    }

    protected JsonObject sslConfig() {
        return this.config().getJsonObject("ssl", new JsonObject());
    }
}

