/*
 * Decompiled with CFR 0.152.
 */
package ph.com.nightowlstudios.entity;

import io.vavr.CheckedFunction0;
import io.vavr.control.Try;
import io.vertx.core.json.Json;
import io.vertx.core.json.JsonObject;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.UUID;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import ph.com.nightowlstudios.entity.Column;
import ph.com.nightowlstudios.entity.Table;
import ph.com.nightowlstudios.utils.Utils;

public interface Entity {
    public static <T extends Entity> T setId(T entity, UUID id) {
        try {
            FieldUtils.writeField(entity, (String)"id", (Object)id, (boolean)true);
            return entity;
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new IllegalStateException(String.format("Error setting id of %s entity", entity.getClass().getName()));
        }
    }

    public static <T extends Entity> String getTableName(Class<T> entity) {
        return entity.getAnnotation(Table.class).value();
    }

    public static <T extends Entity> String[] getColumns(Class<T> clasz) {
        return (String[])Arrays.stream(clasz.getDeclaredFields()).filter(field -> field.isAnnotationPresent(Column.class)).map(field -> field.getDeclaredAnnotation(Column.class).value()).toArray(String[]::new);
    }

    public static <T extends Entity> String[] getColumnsWithoutId(Class<T> clasz) {
        return (String[])Arrays.stream(clasz.getDeclaredFields()).filter(field -> field.isAnnotationPresent(Column.class)).filter(field -> !StringUtils.equals((CharSequence)field.getName(), (CharSequence)"id")).map(field -> field.getDeclaredAnnotation(Column.class).value()).toArray(String[]::new);
    }

    public static <T extends Entity> String column(Class<T> entityClass, String column) {
        return String.format("%s.%s", Entity.getTableName(entityClass), column);
    }

    public static <T extends Entity> JsonObject toJson(T entity) {
        return Utils.camelCaseKeys(JsonObject.mapFrom(entity));
    }

    public static <T extends Entity> T fromJson(JsonObject json, Class<T> entityClass) {
        return (T)((Entity)Utils.camelCaseKeys(json).mapTo(entityClass));
    }

    public static <T extends Entity> T merge(T from, T to) {
        Entity result = (Entity)Json.decodeValue((String)new JsonObject().encode(), from.getClass());
        for (Field field : result.getClass().getDeclaredFields()) {
            String prefix = field.getType().equals(Boolean.TYPE) ? "is" : "get";
            Supplier<Object> toValue = () -> Try.of((CheckedFunction0 & Serializable)() -> to.getClass().getDeclaredMethod(prefix + StringUtils.capitalize((String)field.getName()), new Class[0]).invoke((Object)to, new Object[0])).getOrNull();
            Supplier<Object> fromValue = () -> Try.of((CheckedFunction0 & Serializable)() -> from.getClass().getDeclaredMethod(prefix + StringUtils.capitalize((String)field.getName()), new Class[0]).invoke((Object)from, new Object[0])).getOrNull();
            if (toValue.get() == null) {
                Try.of((CheckedFunction0 & Serializable)() -> result.getClass().getDeclaredMethod("set" + StringUtils.capitalize((String)field.getName()), field.getType()).invoke((Object)result, fromValue.get()));
                continue;
            }
            Try.of((CheckedFunction0 & Serializable)() -> result.getClass().getDeclaredMethod("set" + StringUtils.capitalize((String)field.getName()), field.getType()).invoke((Object)result, toValue.get()));
        }
        return (T)result;
    }
}

