/*
 * Decompiled with CFR 0.152.
 */
package ph.com.nightowlstudios.utils;

import io.vertx.core.json.JsonObject;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public final class Utils {
    private static final String UNDERSCORE = "_";

    private Utils() {
    }

    public static <T> Optional<T> getFirstElement(List<T> list) {
        return list.isEmpty() ? Optional.empty() : Optional.ofNullable(list.get(0));
    }

    public static JsonObject camelCaseKeys(JsonObject json) {
        ((Stream)json.stream().parallel()).filter(e -> ((String)e.getKey()).contains(UNDERSCORE)).forEach(e -> {
            json.put(Utils.toCamelCase((String)e.getKey()), e.getValue());
            json.remove((String)e.getKey());
        });
        return json;
    }

    public static String toCamelCase(String word) {
        return Utils.toCamelCase(word, UNDERSCORE);
    }

    public static String toCamelCase(String word, String separator) {
        if (StringUtils.isBlank((CharSequence)word)) {
            return "";
        }
        String[] tokens = word.split(separator);
        if (tokens.length == 1) {
            return tokens[0].trim().toLowerCase();
        }
        String head = tokens[0];
        String[] tail = Arrays.copyOfRange(tokens, 1, tokens.length);
        return head.toLowerCase() + ((Stream)Arrays.stream(tail).sequential()).map(StringUtils::capitalize).collect(Collectors.joining());
    }
}

