/*
 * Decompiled with CFR 0.152.
 */
package ph.com.nightowlstudios.core;

import io.vertx.core.AbstractVerticle;
import io.vertx.core.CompositeFuture;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServer;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.bridge.PermittedOptions;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.ErrorHandler;
import io.vertx.ext.web.handler.LoggerHandler;
import io.vertx.ext.web.handler.sockjs.SockJSBridgeOptions;
import io.vertx.ext.web.handler.sockjs.SockJSHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ph.com.nightowlstudios.core.Edge;
import ph.com.nightowlstudios.core.HttpServerVerticle;
import ph.com.nightowlstudios.resource.Resource;
import ph.com.nightowlstudios.service.Service;

public abstract class ApplicationVerticle
extends AbstractVerticle {
    private final HttpServerVerticle serverVerticle;
    private final Map<Class<?>, DeploymentOptions> serviceVerticles = new HashMap();
    private static final Logger log = LoggerFactory.getLogger(ApplicationVerticle.class);
    private static final Set<HttpMethod> ALLOWED_METHODS = new HashSet<HttpMethod>(Arrays.asList(HttpMethod.GET, HttpMethod.PUT, HttpMethod.POST, HttpMethod.PATCH, HttpMethod.DELETE, HttpMethod.OPTIONS));
    private static final Set<String> ALLOWED_HEADERS = new HashSet<String>(Arrays.asList(HttpHeaders.CONTENT_TYPE.toString(), HttpHeaders.AUTHORIZATION.toString(), HttpHeaders.ACCESS_CONTROL_ALLOW_ORIGIN.toString(), HttpHeaders.ACCESS_CONTROL_ALLOW_HEADERS.toString(), HttpHeaders.ACCESS_CONTROL_REQUEST_METHOD.toString(), HttpHeaders.ACCESS_CONTROL_ALLOW_CREDENTIALS.toString()));
    private static final Set<String> EXPOSED_HEADERS = new HashSet<String>(Collections.singletonList(HttpHeaders.AUTHORIZATION.toString()));
    static final String BANNER_TXT = "\n\u2593\u2588\u2588\u2588\u2588\u2588 \u2593\u2588\u2588\u2588\u2588\u2588\u2584   \u2584\u2588\u2588\u2588\u2588 \u2593\u2588\u2588\u2588\u2588\u2588    \n\u2593\u2588   \u2580 \u2592\u2588\u2588\u2580 \u2588\u2588\u258c \u2588\u2588\u2592 \u2580\u2588\u2592\u2593\u2588   \u2580    \n\u2592\u2588\u2588\u2588   \u2591\u2588\u2588   \u2588\u258c\u2592\u2588\u2588\u2591\u2584\u2584\u2584\u2591\u2592\u2588\u2588\u2588      \n\u2592\u2593\u2588  \u2584 \u2591\u2593\u2588\u2584   \u258c\u2591\u2593\u2588  \u2588\u2588\u2593\u2592\u2593\u2588  \u2584    \n\u2591\u2592\u2588\u2588\u2588\u2588\u2592\u2591\u2592\u2588\u2588\u2588\u2588\u2593 \u2591\u2592\u2593\u2588\u2588\u2588\u2580\u2592\u2591\u2592\u2588\u2588\u2588\u2588\u2592   \n\u2591\u2591 \u2592\u2591 \u2591 \u2592\u2592\u2593  \u2592  \u2591\u2592   \u2592 \u2591\u2591 \u2592\u2591 \u2591   \n \u2591 \u2591  \u2591 \u2591 \u2592  \u2592   \u2591   \u2591  \u2591 \u2591  \u2591   \n   \u2591    \u2591 \u2591  \u2591 \u2591 \u2591   \u2591    \u2591      \n   \u2591  \u2591   \u2591          \u2591    \u2591  \u2591   \n        \u2591                        \n";

    public ApplicationVerticle() {
        this.serverVerticle = new HttpServerVerticle(this::allowCORSCredentials, this::allowedMethods, this::allowedHeaders, this::exposedHeaders, this::apiPrefix, this::beforeRouterCreate, this::createRouteLogHandler, this::createRouteFailureHandler, this::getResourceClasses, this::setupRoutes, this::webSocketPrefix, this::createWebSocketRouter, this::bannerText, this::onStart, this::onStartFail);
    }

    public void start(Promise<Void> startPromise) {
        this.setup();
        CompositeFuture.all(this.buildDeployList()).onSuccess(none -> startPromise.complete()).onFailure(failure -> {
            log.error("Unable to deploy Edge Application", failure.getCause());
            startPromise.fail(failure.getMessage());
        });
    }

    public abstract void setup();

    private List<Future> buildDeployList() {
        ArrayList<Future> list = new ArrayList<Future>();
        this.serviceVerticles.forEach((service, options) -> list.add(this.createLauncher((Class<?>)service, (DeploymentOptions)options)));
        list.add(this.createLauncher((Verticle)this.serverVerticle));
        return list;
    }

    private Future<String> createLauncher(Class<?> service, DeploymentOptions options) {
        options.setConfig(Optional.ofNullable(options.getConfig()).orElse(new JsonObject()).mergeIn(this.config()));
        return this.vertx.deployVerticle(service, options).onSuccess(none -> log.info("Deployed {} verticle successfully.", (Object)service.getName())).onFailure(failure -> log.error("Error deploying {}.", (Object)service.getName()));
    }

    private Future<String> createLauncher(Verticle verticle) {
        return this.vertx.deployVerticle(verticle, new DeploymentOptions().setConfig(this.config()));
    }

    @SafeVarargs
    protected final <T extends Service> void registerService(Class<T> ... services) {
        for (Class<T> service : services) {
            this.registerService(service, new DeploymentOptions());
        }
    }

    protected <T extends Service> void registerService(Class<T> service, DeploymentOptions options) {
        this.serviceVerticles.put(service, options);
        Edge.registerService(service);
    }

    protected void beforeRouterCreate(Router router) {
    }

    protected void setupRoutes(Router apiRouter) {
    }

    protected void onStart(HttpServer httpServer) {
    }

    protected void onStartFail(Throwable error) {
    }

    protected final String appName() {
        return this.config().getString("name", "edge.api");
    }

    protected final String version() {
        return this.config().getString("version", "1.0");
    }

    protected boolean allowCORSCredentials() {
        return true;
    }

    protected Set<HttpMethod> allowedMethods() {
        return ALLOWED_METHODS;
    }

    protected Set<String> allowedHeaders() {
        return ALLOWED_HEADERS;
    }

    protected Set<String> exposedHeaders() {
        return EXPOSED_HEADERS;
    }

    protected String apiPrefix() {
        String prefix = this.config().getString("prefix", "api");
        return String.format("/%s/%s", prefix.trim(), this.version().trim());
    }

    protected String webSocketPrefix() {
        return this.config().getString("wsPrefix", "/ws");
    }

    protected String bannerText() {
        return BANNER_TXT;
    }

    protected Handler<RoutingContext> createRouteLogHandler() {
        return LoggerHandler.create();
    }

    protected Handler<RoutingContext> createRouteFailureHandler() {
        return ErrorHandler.create((Vertx)this.getVertx());
    }

    protected abstract <R extends Resource> Class<R>[] getResourceClasses();

    private Router createWebSocketRouter(Vertx vertx) throws RuntimeException {
        SockJSHandler handler = SockJSHandler.create((Vertx)vertx);
        SockJSBridgeOptions options = new SockJSBridgeOptions();
        ArrayList<PermittedOptions> inbound = new ArrayList<PermittedOptions>(this.addInboundSocketRules());
        options.setInboundPermitteds(inbound);
        ArrayList<PermittedOptions> outbound = new ArrayList<PermittedOptions>(this.addOutboundSocketRules());
        options.setOutboundPermitteds(outbound);
        return handler.bridge(options);
    }

    protected List<PermittedOptions> addInboundSocketRules() {
        return new ArrayList<PermittedOptions>();
    }

    protected List<PermittedOptions> addOutboundSocketRules() {
        return new ArrayList<PermittedOptions>();
    }
}

