/*
 * Decompiled with CFR 0.152.
 */
package operations.string;

import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import operation.StandardLogicOperation;
import operations.string.StringUnwrapStrategy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import utils.AnyUtilsKt;
import utils.ListUtilsKt;
import utils.StringUtilsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010 \n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0007H\u0016J\u0014\u0010\t\u001a\u00020\n*\u00020\u00052\u0006\u0010\u000b\u001a\u00020\nH\u0002J\u0014\u0010\f\u001a\u00020\n*\u00020\n2\u0006\u0010\r\u001a\u00020\nH\u0002J\u001e\u0010\u000e\u001a\u0004\u0018\u00010\u0005*\u00020\u00052\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\nH\u0002J\u001c\u0010\u0010\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\nH\u0002J\u001c\u0010\u0011\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\nH\u0002J\u001c\u0010\u0012\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\nH\u0002J\u0014\u0010\u0013\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\u000b\u001a\u00020\nH\u0002J$\u0010\u0014\u001a\u00020\u0005*\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00152\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\nH\u0002\u00a8\u0006\u0016"}, d2={"Loperations/string/Substr;", "Loperation/StandardLogicOperation;", "Loperations/string/StringUnwrapStrategy;", "()V", "evaluateLogic", "", "expression", "", "data", "constrainNegativeStartIndex", "", "startIndex", "constrainOutOfBoundsCharsCount", "sourceStringLength", "fromStartIndexToEndIndex", "charsCount", "negativeArgsSubstring", "negativeStartIndexSubString", "notNegativeArgsSubstring", "startIndexSubstring", "substringOrEmpty", "", "core"})
public final class Substr
implements StandardLogicOperation,
StringUnwrapStrategy {
    @NotNull
    public static final Substr INSTANCE = new Substr();

    private Substr() {
    }

    @NotNull
    public String evaluateLogic(@Nullable Object expression, @Nullable Object data) {
        List $this$evaluateLogic_u24lambda_u2d0 = AnyUtilsKt.getAsList((Object)expression);
        boolean bl = false;
        int startIndex = StringUtilsKt.getIntOrZero((String)String.valueOf(ListUtilsKt.secondOrNull((List)$this$evaluateLogic_u24lambda_u2d0)));
        int charsCount = StringUtilsKt.getIntOrZero((String)String.valueOf(ListUtilsKt.thirdOrNull((List)$this$evaluateLogic_u24lambda_u2d0)));
        return INSTANCE.substringOrEmpty($this$evaluateLogic_u24lambda_u2d0, startIndex, charsCount);
    }

    private final String substringOrEmpty(List<? extends Object> $this$substringOrEmpty, int startIndex, int charsCount) {
        Object object;
        String baseString = CollectionsKt.joinToString$default((Iterable)this.unwrapValueAsString(CollectionsKt.firstOrNull($this$substringOrEmpty)), (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
        Object object2 = $this$substringOrEmpty;
        try {
            List<? extends Object> $this$substringOrEmpty_u24lambda_u2d1 = object2;
            boolean bl = false;
            object = Result.constructor-impl((Object)($this$substringOrEmpty_u24lambda_u2d1.size() == 2 ? INSTANCE.startIndexSubstring(baseString, startIndex) : ($this$substringOrEmpty_u24lambda_u2d1.size() > 2 ? INSTANCE.fromStartIndexToEndIndex(baseString, startIndex, charsCount) : baseString)));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        String string = (String)(Result.isFailure-impl((Object)object2) ? null : object2);
        if (string == null) {
            string = "";
        }
        return string;
    }

    private final String startIndexSubstring(String $this$startIndexSubstring, int startIndex) {
        String string;
        if (startIndex >= 0) {
            String string2 = $this$startIndexSubstring.substring(startIndex);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
        } else if (Math.abs(startIndex) <= $this$startIndexSubstring.length()) {
            String string3 = $this$startIndexSubstring.substring($this$startIndexSubstring.length() + startIndex);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
        } else {
            string = $this$startIndexSubstring;
        }
        return string;
    }

    private final String fromStartIndexToEndIndex(String $this$fromStartIndexToEndIndex, int startIndex, int charsCount) {
        String string;
        if (startIndex >= 0 && charsCount > 0) {
            string = this.notNegativeArgsSubstring($this$fromStartIndexToEndIndex, startIndex, charsCount);
        } else if (startIndex >= 0 && charsCount < 0) {
            String string2 = $this$fromStartIndexToEndIndex.substring(startIndex, $this$fromStartIndexToEndIndex.length() + charsCount);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        } else {
            string = startIndex < 0 && charsCount < 0 ? this.negativeArgsSubstring($this$fromStartIndexToEndIndex, startIndex, charsCount) : (startIndex < 0 && charsCount > 0 ? this.negativeStartIndexSubString($this$fromStartIndexToEndIndex, startIndex, charsCount) : null);
        }
        return string;
    }

    private final String notNegativeArgsSubstring(String $this$notNegativeArgsSubstring, int startIndex, int charsCount) {
        int outOfBoundsSafeCount = this.constrainOutOfBoundsCharsCount(startIndex + charsCount, $this$notNegativeArgsSubstring.length());
        String string = $this$notNegativeArgsSubstring.substring(startIndex, outOfBoundsSafeCount);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        return string;
    }

    private final String negativeArgsSubstring(String $this$negativeArgsSubstring, int startIndex, int charsCount) {
        int outOfBoundsSafeStartIndex = this.constrainNegativeStartIndex($this$negativeArgsSubstring, startIndex);
        int outOfBoundsSafeCount = this.constrainOutOfBoundsCharsCount($this$negativeArgsSubstring.length() + charsCount, $this$negativeArgsSubstring.length());
        String string = $this$negativeArgsSubstring.substring(outOfBoundsSafeStartIndex, outOfBoundsSafeCount);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        return string;
    }

    private final String negativeStartIndexSubString(String $this$negativeStartIndexSubString, int startIndex, int charsCount) {
        int outOfBoundsSafeStartIndex = this.constrainNegativeStartIndex($this$negativeStartIndexSubString, startIndex);
        int outOfBoundsSafeCount = this.constrainOutOfBoundsCharsCount(outOfBoundsSafeStartIndex + charsCount, $this$negativeStartIndexSubString.length());
        String string = $this$negativeStartIndexSubString.substring(outOfBoundsSafeStartIndex, outOfBoundsSafeCount);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        return string;
    }

    private final int constrainNegativeStartIndex(String $this$constrainNegativeStartIndex, int startIndex) {
        Integer n = $this$constrainNegativeStartIndex.length() + startIndex;
        int it = ((Number)n).intValue();
        boolean bl = false;
        Integer n2 = it >= 0 ? n : null;
        return n2 != null ? n2 : 0;
    }

    private final int constrainOutOfBoundsCharsCount(int $this$constrainOutOfBoundsCharsCount, int sourceStringLength) {
        Integer n = $this$constrainOutOfBoundsCharsCount;
        int it = ((Number)n).intValue();
        boolean bl = false;
        Integer n2 = it <= sourceStringLength ? n : null;
        return n2 != null ? n2 : sourceStringLength;
    }

    @Override
    @NotNull
    public List<String> unwrapValueAsString(@Nullable Object wrappedValue) {
        return StringUnwrapStrategy.DefaultImpls.unwrapValueAsString(this, wrappedValue);
    }
}

