/*
 * Decompiled with CFR 0.152.
 */
package operations.numeric;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000f\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b`\u0018\u00002\u00020\u0001J&\u0010\u0002\u001a\u0004\u0018\u00010\u00032\f\u0010\u0004\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00052\f\u0010\u0006\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0005H\u0002J4\u0010\u0007\u001a\u00020\b2\u0010\u0010\t\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0018\u00010\n2\u0018\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b0\fH\u0016J4\u0010\r\u001a\u00020\b2\u0010\u0010\t\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0018\u00010\n2\u0018\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b0\fH\u0016J&\u0010\u000e\u001a\u0004\u0018\u00010\u00032\f\u0010\u0004\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00052\f\u0010\u0006\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0005H\u0002J&\u0010\u000f\u001a\u0004\u0018\u00010\u00032\f\u0010\u0004\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00052\f\u0010\u0006\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0005H\u0002J2\u0010\u0010\u001a\u00020\b*\u000e\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u00050\n2\u0018\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b0\fH\u0002J2\u0010\u0011\u001a\u00020\b*\u000e\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u00050\n2\u0018\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b0\fH\u0002J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\b*\u0004\u0018\u00010\u0001H\u0002\u00a8\u0006\u0013"}, d2={"Loperations/numeric/ComparingOperation;", "", "booleanCompare", "", "first", "", "second", "compareListOfTwo", "", "values", "", "operator", "Lkotlin/Function2;", "compareOrBetween", "compareOrNull", "nonPrimitiveCompare", "between", "compare", "toBooleanOrNull", "json-logic-kmp"})
public interface ComparingOperation {
    public boolean compareListOfTwo(@Nullable List<? extends Object> var1, @NotNull Function2<? super Integer, ? super Integer, Boolean> var2);

    public boolean compareOrBetween(@Nullable List<? extends Object> var1, @NotNull Function2<? super Integer, ? super Integer, Boolean> var2);

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        public static boolean compareListOfTwo(@NotNull ComparingOperation this_, @Nullable List<? extends Object> values, @NotNull Function2<? super Integer, ? super Integer, Boolean> operator) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(operator, (String)"operator");
            List<? extends Object> list = values;
            if (list == null) {
                bl = false;
            } else {
                List<Comparable<?>> list2 = AnyUtilsKt.getComparableList(list);
                if (list2 == null) {
                    bl = false;
                } else {
                    boolean bl2;
                    List<Comparable<?>> list3;
                    List<Comparable<?>> it = list3 = list2;
                    boolean bl3 = false;
                    List<Comparable<?>> list4 = it.size() >= 2 ? list3 : null;
                    bl = list4 == null ? false : (bl2 = DefaultImpls.compare(this_, list4, operator));
                }
            }
            return bl;
        }

        public static boolean compareOrBetween(@NotNull ComparingOperation this_, @Nullable List<? extends Object> values, @NotNull Function2<? super Integer, ? super Integer, Boolean> operator) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(operator, (String)"operator");
            List<? extends Object> list = values;
            if (list == null) {
                bl = false;
            } else {
                List<Comparable<?>> list2 = AnyUtilsKt.getComparableList(list);
                if (list2 == null) {
                    bl = false;
                } else {
                    boolean bl2;
                    List<Comparable<?>> comparableList = list2;
                    boolean bl3 = false;
                    bl = bl2 = comparableList.size() == 2 ? DefaultImpls.compare(this_, comparableList, operator) : (comparableList.size() > 2 ? DefaultImpls.between(this_, comparableList, operator) : false);
                }
            }
            return bl;
        }

        private static boolean compare(ComparingOperation this_, List<? extends Comparable<?>> receiver, Function2<? super Integer, ? super Integer, Boolean> operator) {
            boolean bl;
            Integer n = DefaultImpls.compareOrNull(this_, (Comparable)CollectionsKt.firstOrNull(receiver), ListUtilsKt.secondOrNull(receiver));
            if (n == null) {
                bl = false;
            } else {
                boolean bl2;
                int it = ((Number)n).intValue();
                boolean bl3 = false;
                bl = bl2 = ((Boolean)operator.invoke((Object)it, (Object)0)).booleanValue();
            }
            return bl;
        }

        private static boolean between(ComparingOperation this_, List<? extends Comparable<?>> receiver, Function2<? super Integer, ? super Integer, Boolean> operator) {
            Integer firstEvaluation = DefaultImpls.compareOrNull(this_, (Comparable)CollectionsKt.firstOrNull(receiver), ListUtilsKt.secondOrNull(receiver));
            Integer secondEvaluation = DefaultImpls.compareOrNull(this_, ListUtilsKt.secondOrNull(receiver), (Comparable)CollectionsKt.getOrNull(receiver, (int)2));
            return firstEvaluation != null && secondEvaluation != null ? ((Boolean)operator.invoke((Object)firstEvaluation, (Object)0)).booleanValue() && ((Boolean)operator.invoke((Object)secondEvaluation, (Object)0)).booleanValue() : false;
        }

        private static Integer compareOrNull(ComparingOperation this_, Comparable<?> first, Comparable<?> second) {
            Integer n;
            if (first instanceof Number && second instanceof Number) {
                n = ComparisonsKt.compareValues((Comparable)Double.valueOf(((Number)((Object)first)).doubleValue()), (Comparable)Double.valueOf(((Number)((Object)second)).doubleValue()));
            } else if (first instanceof String && second instanceof Number) {
                Double d = StringsKt.toDoubleOrNull((String)((String)((Object)first)));
                if (d == null) {
                    n = null;
                } else {
                    double it = ((Number)d).doubleValue();
                    boolean bl = false;
                    n = ComparisonsKt.compareValues((Comparable)Double.valueOf(it), (Comparable)Double.valueOf(((Number)((Object)second)).doubleValue()));
                }
            } else if (first instanceof Number && second instanceof String) {
                Double d = StringsKt.toDoubleOrNull((String)((String)((Object)second)));
                if (d == null) {
                    n = null;
                } else {
                    double it = ((Number)d).doubleValue();
                    boolean bl = false;
                    n = ComparisonsKt.compareValues((Comparable)Double.valueOf(((Number)((Object)first)).doubleValue()), (Comparable)Double.valueOf(it));
                }
            } else {
                n = first instanceof Boolean || second instanceof Boolean ? DefaultImpls.booleanCompare(this_, first, second) : DefaultImpls.nonPrimitiveCompare(this_, first, second);
            }
            return n;
        }

        private static Integer booleanCompare(ComparingOperation this_, Comparable<?> first, Comparable<?> second) {
            Boolean castedFirst = DefaultImpls.toBooleanOrNull(this_, first);
            Boolean castedSecond = DefaultImpls.toBooleanOrNull(this_, second);
            return castedFirst != null && castedSecond != null ? Integer.valueOf(ComparisonsKt.compareValues((Comparable)castedFirst, (Comparable)castedSecond)) : null;
        }

        private static Boolean toBooleanOrNull(ComparingOperation this_, Object receiver) {
            Boolean bl;
            Object object = receiver;
            if (object instanceof Boolean) {
                bl = (Boolean)receiver;
            } else if (object instanceof Number) {
                bl = ((Number)receiver).longValue() > 0L;
            } else if (object instanceof String) {
                Double d = StringsKt.toDoubleOrNull((String)((String)receiver));
                if (d == null) {
                    bl = null;
                } else {
                    long l;
                    long it = l = (long)d.doubleValue();
                    boolean bl2 = false;
                    bl = it > 0L;
                }
            } else {
                bl = null;
            }
            return bl;
        }

        private static Integer nonPrimitiveCompare(ComparingOperation this_, Comparable<?> first, Comparable<?> second) {
            return first != null && second != null && Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(first.getClass()), (Object)Reflection.getOrCreateKotlinClass(second.getClass())) ? Integer.valueOf(ComparisonsKt.compareValues(first, second)) : null;
        }
    }
}

