/*
 * Decompiled with CFR 0.152.
 */
package string.compareToDate;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.datetime.Instant;
import org.jetbrains.annotations.NotNull;
import string.compareToDate.ComparePrecision;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\r"}, d2={"Lstring/compareToDate/ComparePrecisionDateFormatter;", "", "()V", "formatDate", "Lkotlinx/datetime/Instant;", "isoDate", "", "precision", "Lstring/compareToDate/ComparePrecision;", "toDateSuffix", "toPosition", "", "Companion", "operations-stdlib"})
public final class ComparePrecisionDateFormatter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int secondPosition = 19;
    private static final int minutePosition = 16;
    private static final int hourPosition = 13;
    private static final int dayPosition = 10;
    private static final int monthPosition = 7;
    private static final int yearPosition = 4;
    private static final int dateLength = 24;
    @NotNull
    private static final String empty = "";
    @NotNull
    private static final String secondsPrecision = ".001Z";
    @NotNull
    private static final String minutesPrecision = ":00.001Z";
    @NotNull
    private static final String hoursPrecision = ":00:00.001Z";
    @NotNull
    private static final String daysPrecision = "T00:00:00.001Z";
    @NotNull
    private static final String monthsPrecision = "-01T00:00:00.001Z";
    @NotNull
    private static final String yearsPrecision = "-01-01T00:00:00.001Z";

    @NotNull
    public final Instant formatDate(@NotNull String isoDate, @NotNull ComparePrecision precision) {
        Intrinsics.checkNotNullParameter((Object)isoDate, (String)"isoDate");
        Intrinsics.checkNotNullParameter((Object)((Object)precision), (String)"precision");
        String string = isoDate.substring(0, this.toPosition(precision));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        return Instant.Companion.parse(string + this.toDateSuffix(precision));
    }

    private final String toDateSuffix(ComparePrecision precision) {
        String string;
        switch (WhenMappings.$EnumSwitchMapping$0[precision.ordinal()]) {
            case 1: {
                string = empty;
                break;
            }
            case 2: {
                string = secondsPrecision;
                break;
            }
            case 3: {
                string = minutesPrecision;
                break;
            }
            case 4: {
                string = hoursPrecision;
                break;
            }
            case 5: {
                string = daysPrecision;
                break;
            }
            case 6: {
                string = monthsPrecision;
                break;
            }
            case 7: {
                string = yearsPrecision;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    private final int toPosition(ComparePrecision precision) {
        int n;
        switch (WhenMappings.$EnumSwitchMapping$0[precision.ordinal()]) {
            case 1: {
                n = 24;
                break;
            }
            case 2: {
                n = 19;
                break;
            }
            case 3: {
                n = 16;
                break;
            }
            case 4: {
                n = 13;
                break;
            }
            case 5: {
                n = 10;
                break;
            }
            case 6: {
                n = 7;
                break;
            }
            case 7: {
                n = 4;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return n;
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ComparePrecision.values().length];
            try {
                nArray[ComparePrecision.MILLISECOND.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ComparePrecision.SECOND.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ComparePrecision.MINUTE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ComparePrecision.HOUR.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ComparePrecision.DAY.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ComparePrecision.MONTH.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ComparePrecision.YEAR.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\f\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lstring/compareToDate/ComparePrecisionDateFormatter$Companion;", "", "()V", "dateLength", "", "dayPosition", "daysPrecision", "", "empty", "hourPosition", "hoursPrecision", "minutePosition", "minutesPrecision", "monthPosition", "monthsPrecision", "secondPosition", "secondsPrecision", "yearPosition", "yearsPrecision", "operations-stdlib"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

