/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.search.solr.ids.filter;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.IndexSearcher;
import org.apache.solr.search.DelegatingCollector;
import org.apache.solr.search.ExtendedQueryBase;
import org.apache.solr.search.PostFilter;
import pl.allegro.search.solr.ids.filter.bufferbuilder.IdsBufferBuilder;

public class IdsExportFilter
extends ExtendedQueryBase
implements PostFilter {
    private final Map<Object, Object> reqContext;
    private final int bufferInitialSize;
    private final String field;

    public IdsExportFilter(Map<Object, Object> context, int bufferInitialSize, String field) {
        this.reqContext = context;
        this.bufferInitialSize = bufferInitialSize;
        this.field = field;
    }

    public DelegatingCollector getFilterCollector(IndexSearcher searcher) {
        return new DelegatingCollector(){
            IdsBufferBuilder idsBufferBuilder;

            protected void doSetNextReader(LeafReaderContext context) throws IOException {
                super.doSetNextReader(context);
                if (this.idsBufferBuilder == null) {
                    DocValuesType docValuesType = context.reader().getFieldInfos().fieldInfo(IdsExportFilter.this.field).getDocValuesType();
                    this.idsBufferBuilder = IdsBufferBuilder.newIdsBufferBuilder(docValuesType, IdsExportFilter.this.field, IdsExportFilter.this.bufferInitialSize);
                }
                this.idsBufferBuilder.doSetNextReader(context);
            }

            public void collect(int doc) throws IOException {
                super.collect(doc);
                this.idsBufferBuilder.collect(doc);
            }

            public void finish() throws IOException {
                super.finish();
                IdsExportFilter.this.reqContext.put("pl/allegro/search/solr/ids", this.idsBufferBuilder.build());
            }
        };
    }

    public int getCost() {
        return Math.max(super.getCost(), 100);
    }

    public boolean getCache() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        IdsExportFilter that = (IdsExportFilter)((Object)o);
        return this.bufferInitialSize == that.bufferInitialSize && Objects.equals(this.reqContext, that.reqContext);
    }

    public int hashCode() {
        return Objects.hash(this.reqContext, this.bufferInitialSize);
    }
}

