/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.search.solr.ids.filter;

import java.util.Map;
import org.apache.lucene.search.Query;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.QParser;
import org.apache.solr.search.QParserPlugin;
import pl.allegro.search.solr.ids.filter.IdsExportFilter;

public class IdsExportFilterParserPlugin
extends QParserPlugin {
    private static final int DEFAULT_BUFFER_INITIAL_SIZE = 100000;
    private static final String DEFAULT_DEFAULT_INDEX_FIELD = "doc_id";
    private int bufferInitialSize = 100000;
    private String defaultIndexField = "doc_id";

    public void init(NamedList args) {
        super.init(args);
        if (args.get("bufferInitialSize") != null) {
            this.bufferInitialSize = (Integer)args.get("bufferInitialSize");
        }
        if (args.get("defaultIndexField") != null) {
            this.defaultIndexField = (String)args.get("defaultIndexField");
        }
    }

    public QParser createParser(String queryString, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
        final String indexField = localParams.get("field", this.defaultIndexField);
        if (!req.getSchema().getField(indexField).hasDocValues()) {
            throw new RuntimeException("IdsExportFilter supports only fields with docValues. Field " + indexField + " doesn't have them.");
        }
        return new QParser(queryString, localParams, params, req){

            public Query parse() {
                Map context = this.req.getContext();
                return new IdsExportFilter(context, IdsExportFilterParserPlugin.this.bufferInitialSize, indexField);
            }
        };
    }
}

