/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.search.solr.ids.filter.bufferbuilder;

import com.carrotsearch.hppc.LongArrayList;
import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import pl.allegro.search.solr.ids.buffer.IdsBuffer;
import pl.allegro.search.solr.ids.buffer.LongArrayListIdsBuffer;
import pl.allegro.search.solr.ids.filter.bufferbuilder.IdsBufferBuilder;

public class SortedNumericDocValuesIdsBufferBuilder
implements IdsBufferBuilder {
    private final String field;
    private final LongArrayList buffer;
    private SortedNumericDocValues docValues;

    public SortedNumericDocValuesIdsBufferBuilder(String field, int bufferInitialSize) {
        this.field = field;
        this.buffer = new LongArrayList(bufferInitialSize);
    }

    @Override
    public void doSetNextReader(LeafReaderContext context) throws IOException {
        this.docValues = context.reader().getSortedNumericDocValues(this.field);
    }

    @Override
    public void collect(int doc) throws IOException {
        if (this.docValues != null && this.docValues.advanceExact(doc)) {
            for (int i = 0; i < this.docValues.docValueCount(); ++i) {
                this.buffer.add(this.docValues.nextValue());
            }
        }
    }

    @Override
    public IdsBuffer build() {
        return new LongArrayListIdsBuffer(this.buffer);
    }
}

