/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.search.solr.ids.filter.bufferbuilder;

import java.io.IOException;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.LeafReaderContext;
import pl.allegro.search.solr.ids.buffer.IdsBuffer;
import pl.allegro.search.solr.ids.filter.bufferbuilder.BinaryDocValuesIdsBufferBuilder;
import pl.allegro.search.solr.ids.filter.bufferbuilder.NumericDocValuesIdsBufferBuilder;
import pl.allegro.search.solr.ids.filter.bufferbuilder.SortedDocValuesIdsBufferBuilder;
import pl.allegro.search.solr.ids.filter.bufferbuilder.SortedNumericDocValuesIdsBufferBuilder;
import pl.allegro.search.solr.ids.filter.bufferbuilder.SortedSetDocValuesIdsBufferBuilder;

public interface IdsBufferBuilder {
    public static IdsBufferBuilder newIdsBufferBuilder(DocValuesType docValuesType, String field, int bufferInitialSize) {
        switch (docValuesType) {
            case NUMERIC: {
                return new NumericDocValuesIdsBufferBuilder(field, bufferInitialSize);
            }
            case SORTED_NUMERIC: {
                return new SortedNumericDocValuesIdsBufferBuilder(field, bufferInitialSize);
            }
            case BINARY: {
                return new BinaryDocValuesIdsBufferBuilder(field, bufferInitialSize);
            }
            case SORTED: {
                return new SortedDocValuesIdsBufferBuilder(field, bufferInitialSize);
            }
            case SORTED_SET: {
                return new SortedSetDocValuesIdsBufferBuilder(field, bufferInitialSize);
            }
        }
        throw new RuntimeException("Unsupported DocValues type " + docValuesType + " for field " + field + ". IdsExportFilter cannot use this type of DocValues.");
    }

    public void doSetNextReader(LeafReaderContext var1) throws IOException;

    public void collect(int var1) throws IOException;

    public IdsBuffer build();
}

