/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.search.solr.ids.filter.bufferbuilder;

import com.carrotsearch.hppc.LongArrayList;
import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import pl.allegro.search.solr.ids.buffer.IdsBuffer;
import pl.allegro.search.solr.ids.buffer.LongArrayListIdsBuffer;
import pl.allegro.search.solr.ids.filter.bufferbuilder.IdsBufferBuilder;

public class NumericDocValuesIdsBufferBuilder
implements IdsBufferBuilder {
    private final String field;
    private final LongArrayList buffer;
    private NumericDocValues docValues;

    public NumericDocValuesIdsBufferBuilder(String field, int bufferInitialSize) {
        this.field = field;
        this.buffer = new LongArrayList(bufferInitialSize);
    }

    @Override
    public void doSetNextReader(LeafReaderContext context) throws IOException {
        this.docValues = context.reader().getNumericDocValues(this.field);
    }

    @Override
    public void collect(int doc) throws IOException {
        if (this.docValues != null && this.docValues.advanceExact(doc)) {
            this.buffer.add(this.docValues.longValue());
        }
    }

    @Override
    public IdsBuffer build() {
        return new LongArrayListIdsBuffer(this.buffer);
    }
}

