/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.search.solr.ids.filter.bufferbuilder;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.util.BytesRef;
import pl.allegro.search.solr.ids.buffer.IdsBuffer;
import pl.allegro.search.solr.ids.buffer.ListOfBytesRefIdsBuffer;
import pl.allegro.search.solr.ids.filter.bufferbuilder.IdsBufferBuilder;

public class SortedDocValuesIdsBufferBuilder
implements IdsBufferBuilder {
    private final String field;
    private final List<BytesRef> buffer;
    private SortedDocValues docValues;

    public SortedDocValuesIdsBufferBuilder(String field, int bufferInitialSize) {
        this.field = field;
        this.buffer = new ArrayList<BytesRef>(bufferInitialSize);
    }

    @Override
    public void doSetNextReader(LeafReaderContext context) throws IOException {
        this.docValues = context.reader().getSortedDocValues(this.field);
    }

    @Override
    public void collect(int doc) throws IOException {
        if (this.docValues != null && this.docValues.advanceExact(doc)) {
            this.buffer.add(BytesRef.deepCopyOf((BytesRef)this.docValues.binaryValue()));
        }
    }

    @Override
    public IdsBuffer build() {
        return new ListOfBytesRefIdsBuffer(this.buffer);
    }
}

