/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.client.okhttp;

import java.io.IOException;
import java.net.URI;
import java.util.concurrent.CompletableFuture;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import pl.allegro.tech.hermes.client.HermesMessage;
import pl.allegro.tech.hermes.client.HermesResponse;
import pl.allegro.tech.hermes.client.HermesResponseBuilder;
import pl.allegro.tech.hermes.client.HermesSender;

public class OkHttpHermesSender
implements HermesSender {
    private final OkHttpClient client;

    public OkHttpHermesSender(OkHttpClient client) {
        this.client = client;
    }

    @Override
    public CompletableFuture<HermesResponse> send(URI uri, HermesMessage message) {
        final CompletableFuture<HermesResponse> future = new CompletableFuture<HermesResponse>();
        RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)message.getContentType()), (byte[])message.getBody());
        Request.Builder builder = new Request.Builder();
        message.consumeHeaders((arg_0, arg_1) -> ((Request.Builder)builder).addHeader(arg_0, arg_1));
        Request request = builder.post(body).url(uri.toString()).build();
        this.client.newCall(request).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                future.completeExceptionally(e);
            }

            public void onResponse(Call call, Response response) throws IOException {
                future.complete(OkHttpHermesSender.this.fromOkHttpResponse(response));
            }
        });
        return future;
    }

    HermesResponse fromOkHttpResponse(Response response) throws IOException {
        return HermesResponseBuilder.hermesResponse().withHeaderSupplier(arg_0 -> ((Response)response).header(arg_0)).withHttpStatus(response.code()).withBody(response.body().string()).withProtocol(response.protocol().toString()).build();
    }
}

