/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.client.restTemplate;

import java.net.URI;
import java.util.concurrent.CompletableFuture;
import org.springframework.http.HttpEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.concurrent.ListenableFutureCallback;
import org.springframework.web.client.AsyncRestTemplate;
import org.springframework.web.client.HttpStatusCodeException;
import pl.allegro.tech.hermes.client.HermesMessage;
import pl.allegro.tech.hermes.client.HermesResponse;
import pl.allegro.tech.hermes.client.HermesResponseBuilder;
import pl.allegro.tech.hermes.client.HermesSender;

public class RestTemplateHermesSender
implements HermesSender {
    private final AsyncRestTemplate template;

    public RestTemplateHermesSender(AsyncRestTemplate template) {
        this.template = template;
    }

    @Override
    public CompletableFuture<HermesResponse> send(URI uri, final HermesMessage message) {
        final CompletableFuture<HermesResponse> future = new CompletableFuture<HermesResponse>();
        this.template.postForEntity(uri, new HttpEntity((Object)message.getBody(), (MultiValueMap)new LinkedMultiValueMap<String, String>(){
            {
                message.consumeHeaders((arg_0, arg_1) -> (this).add(arg_0, arg_1));
            }
        }), String.class).addCallback((ListenableFutureCallback)new ListenableFutureCallback<ResponseEntity>(){

            public void onSuccess(ResponseEntity response) {
                future.complete(RestTemplateHermesSender.this.fromRestTemplateResponse(response));
            }

            public void onFailure(Throwable exception) {
                if (exception instanceof HttpStatusCodeException) {
                    future.complete(RestTemplateHermesSender.this.fromHttpStatusCodeException((HttpStatusCodeException)exception));
                } else {
                    future.completeExceptionally(exception);
                }
            }
        });
        return future;
    }

    private HermesResponse fromRestTemplateResponse(ResponseEntity response) {
        return HermesResponseBuilder.hermesResponse().withHttpStatus(response.getStatusCode().value()).withBody(response.toString()).withHeaderSupplier(header -> response.getHeaders().toSingleValueMap().getOrDefault(header, null)).build();
    }

    private HermesResponse fromHttpStatusCodeException(HttpStatusCodeException exception) {
        return HermesResponseBuilder.hermesResponse().withHttpStatus(exception.getStatusCode().value()).withBody(exception.getResponseBodyAsString()).build();
    }
}

