/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.client;

import java.net.URI;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import pl.allegro.tech.hermes.client.HermesMessage;
import pl.allegro.tech.hermes.client.HermesResponse;
import pl.allegro.tech.hermes.client.HermesResponseBuilder;
import pl.allegro.tech.hermes.client.HermesSender;

public class HermesClient {
    private final HermesSender sender;
    private final int retries;
    private final Predicate<HermesResponse> retryCondition;
    private final String uri;

    HermesClient(HermesSender sender, URI uri, int retries, Predicate<HermesResponse> retryCondition) {
        this.sender = sender;
        this.retries = retries;
        this.retryCondition = retryCondition;
        this.uri = uri.toString() + "/topics/";
    }

    public CompletableFuture<HermesResponse> publish(String topic, String message) {
        return this.publish(new HermesMessage(topic, message));
    }

    public CompletableFuture<HermesResponse> publish(HermesMessage message) {
        return this.publish(message, (HermesResponse response) -> this.retryCondition.test((HermesResponse)response) ? this.sendOnce(message) : CompletableFuture.completedFuture(response));
    }

    private CompletableFuture<HermesResponse> publish(HermesMessage message, Function<HermesResponse, CompletionStage<HermesResponse>> retryDecision) {
        return IntStream.range(0, this.retries).boxed().reduce(this.sendOnce(message), (future, attempt) -> future.thenCompose(retryDecision), (future, attempt) -> future);
    }

    private CompletableFuture<HermesResponse> sendOnce(HermesMessage message) {
        return this.sender.send(URI.create(this.uri + message.getTopic()), message).exceptionally(exception -> HermesResponseBuilder.hermesFailureResponse(exception));
    }
}

