/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.client.jersey;

import java.net.URI;
import java.util.concurrent.CompletableFuture;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.InvocationCallback;
import javax.ws.rs.core.Response;
import pl.allegro.tech.hermes.client.HermesMessage;
import pl.allegro.tech.hermes.client.HermesResponse;
import pl.allegro.tech.hermes.client.HermesResponseBuilder;
import pl.allegro.tech.hermes.client.HermesSender;

public class JerseyHermesSender
implements HermesSender {
    private final Client client;

    public JerseyHermesSender(Client client) {
        this.client = client;
    }

    @Override
    public CompletableFuture<HermesResponse> send(URI uri, HermesMessage message) {
        final CompletableFuture<HermesResponse> future = new CompletableFuture<HermesResponse>();
        this.client.target(uri).request().async().post(Entity.text((Object)message.getBody()), (InvocationCallback)new InvocationCallback<Response>(){

            public void completed(Response response) {
                future.complete(JerseyHermesSender.this.fromJerseyResponse(response));
            }

            public void failed(Throwable exception) {
                future.completeExceptionally(exception);
            }
        });
        return future;
    }

    private HermesResponse fromJerseyResponse(Response response) {
        return HermesResponseBuilder.hermesResponse().withHttpStatus(response.getStatus()).withBody((String)response.readEntity(String.class)).withHeaderSupplier(header -> response.getHeaderString(header)).build();
    }
}

