/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.client;

import java.net.URI;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import pl.allegro.tech.hermes.client.HermesMessage;
import pl.allegro.tech.hermes.client.HermesResponse;
import pl.allegro.tech.hermes.client.HermesResponseBuilder;
import pl.allegro.tech.hermes.client.HermesSender;

public class HermesClient {
    private final HermesSender sender;
    private final String uri;
    private final String defaultContentType;
    private final int retries;
    private final Predicate<HermesResponse> retryCondition;

    HermesClient(HermesSender sender, URI uri, String defaultContentType, int retries, Predicate<HermesResponse> retryCondition) {
        this.sender = sender;
        this.uri = uri.toString() + "/topics/";
        this.defaultContentType = defaultContentType;
        this.retries = retries;
        this.retryCondition = retryCondition;
    }

    public CompletableFuture<HermesResponse> publish(String topic, String message) {
        return this.publish(topic, this.defaultContentType, message);
    }

    public CompletableFuture<HermesResponse> publish(String topic, String contentType, String message) {
        return this.publish(new HermesMessage(topic, message, contentType));
    }

    public CompletableFuture<HermesResponse> publish(HermesMessage message) {
        HermesMessage messageWithContent = message.getContentType() == null ? HermesMessage.appendContentType(message, this.defaultContentType) : message;
        return this.publish(messageWithContent, (HermesResponse response) -> this.retryCondition.test((HermesResponse)response) ? this.sendOnce(messageWithContent) : CompletableFuture.completedFuture(response));
    }

    private CompletableFuture<HermesResponse> publish(HermesMessage message, Function<HermesResponse, CompletionStage<HermesResponse>> retryDecision) {
        return IntStream.range(0, this.retries).boxed().reduce(this.sendOnce(message), (future, attempt) -> future.thenCompose(retryDecision), (future, attempt) -> future);
    }

    private CompletableFuture<HermesResponse> sendOnce(HermesMessage message) {
        return this.sender.send(URI.create(this.uri + message.getTopic()), message).exceptionally(HermesResponseBuilder::hermesFailureResponse);
    }
}

