/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.client;

import com.codahale.metrics.MetricRegistry;
import java.net.URI;
import java.util.function.Predicate;
import pl.allegro.tech.hermes.client.HermesClient;
import pl.allegro.tech.hermes.client.HermesClientBasicRetryCondition;
import pl.allegro.tech.hermes.client.HermesResponse;
import pl.allegro.tech.hermes.client.HermesSender;
import pl.allegro.tech.hermes.client.metrics.MetricsHermesSender;

public class HermesClientBuilder {
    private HermesSender sender;
    private URI uri = URI.create("http://localhost:8080");
    private String defaultContentType = "application/json";
    private int retries = 3;
    private Predicate<HermesResponse> retryCondition = new HermesClientBasicRetryCondition();

    public HermesClientBuilder(HermesSender sender) {
        this.sender = sender;
    }

    public static HermesClientBuilder hermesClient(HermesSender sender) {
        return new HermesClientBuilder(sender);
    }

    public HermesClient build() {
        return new HermesClient(this.sender, this.uri, this.defaultContentType, this.retries, this.retryCondition);
    }

    public HermesClientBuilder withURI(URI uri) {
        this.uri = uri;
        return this;
    }

    public HermesClientBuilder withMetrics(MetricRegistry metrics) {
        this.sender = new MetricsHermesSender(this.sender, metrics);
        return this;
    }

    public HermesClientBuilder withDefaultContentType(String defaultContentType) {
        this.defaultContentType = defaultContentType;
        return this;
    }

    public HermesClientBuilder withRetries(int retries) {
        this.retries = retries;
        return this;
    }

    public HermesClientBuilder withRetries(int retries, Predicate<HermesResponse> retryCondition) {
        this.retryCondition = retryCondition;
        return this.withRetries(retries);
    }
}

