/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.client;

public class HermesMessage {
    private final String topic;
    private final String body;
    private final String contentType;

    public HermesMessage(String topic, String body, String contentType) {
        this.topic = topic;
        this.body = body;
        this.contentType = contentType;
    }

    @Deprecated
    public HermesMessage(String topic, String body) {
        this.topic = topic;
        this.body = body;
        this.contentType = null;
    }

    static HermesMessage appendContentType(HermesMessage message, String contentType) {
        return new HermesMessage(message.getTopic(), message.getBody(), contentType);
    }

    public String getTopic() {
        return this.topic;
    }

    public String getSanitizedTopic() {
        int lastDot = this.getTopic().lastIndexOf(".");
        char[] sanitized = this.getTopic().replaceAll("\\.", "_").toCharArray();
        sanitized[lastDot] = 46;
        return String.valueOf(sanitized);
    }

    public String getBody() {
        return this.body;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String toString() {
        return this.getBody();
    }
}

