/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.client;

import java.util.Optional;
import java.util.function.Function;
import pl.allegro.tech.hermes.client.HermesResponse;

public class HermesResponseBuilder {
    private int statusCode = -1;
    private String body = "";
    private Throwable failureCause;
    private Function<String, String> headerSupplier = header -> null;

    public static HermesResponseBuilder hermesResponse() {
        return new HermesResponseBuilder();
    }

    public static HermesResponse hermesFailureResponse(Throwable exception) {
        return HermesResponseBuilder.hermesResponse().withFailureCause(exception).build();
    }

    public HermesResponseBuilder withHttpStatus(int statusCode) {
        this.statusCode = statusCode;
        return this;
    }

    public HermesResponseBuilder withBody(String body) {
        this.body = body;
        return this;
    }

    public HermesResponseBuilder withFailureCause(Throwable exception) {
        this.failureCause = exception;
        return this;
    }

    public HermesResponseBuilder withHeaderSupplier(Function<String, String> headerSupplier) {
        this.headerSupplier = headerSupplier;
        return this;
    }

    public HermesResponse build() {
        return new HermesResponse(){

            @Override
            public int getHttpStatus() {
                return HermesResponseBuilder.this.statusCode;
            }

            @Override
            public Optional<Throwable> getFailureCause() {
                return Optional.ofNullable(HermesResponseBuilder.this.failureCause);
            }

            @Override
            public String getBody() {
                return HermesResponseBuilder.this.body;
            }

            @Override
            public String getHeader(String header) {
                return (String)HermesResponseBuilder.this.headerSupplier.apply(header);
            }
        };
    }
}

