/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.client.okhttp;

import com.squareup.okhttp.Callback;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.Response;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.CompletableFuture;
import pl.allegro.tech.hermes.client.HermesMessage;
import pl.allegro.tech.hermes.client.HermesResponse;
import pl.allegro.tech.hermes.client.HermesResponseBuilder;
import pl.allegro.tech.hermes.client.HermesSender;

public class OkHttpHermesSender
implements HermesSender {
    private final OkHttpClient client;

    public OkHttpHermesSender(OkHttpClient client) {
        this.client = client;
    }

    @Override
    public CompletableFuture<HermesResponse> send(URI uri, HermesMessage message) {
        final CompletableFuture<HermesResponse> future = new CompletableFuture<HermesResponse>();
        RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)message.getContentType()), (byte[])message.getBody());
        Request.Builder builder = new Request.Builder();
        message.consumeHeaders((arg_0, arg_1) -> ((Request.Builder)builder).addHeader(arg_0, arg_1));
        Request request = builder.post(body).url(uri.toString()).build();
        this.client.newCall(request).enqueue(new Callback(){

            public void onFailure(Request request, IOException e) {
                future.completeExceptionally(e);
            }

            public void onResponse(Response response) throws IOException {
                future.complete(OkHttpHermesSender.this.fromOkHttpResponse(response));
            }
        });
        return future;
    }

    private HermesResponse fromOkHttpResponse(Response response) throws IOException {
        return HermesResponseBuilder.hermesResponse().withHeaderSupplier(arg_0 -> ((Response)response).header(arg_0)).withHttpStatus(response.code()).withBody(response.body().string()).build();
    }
}

