/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.client;

import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;

public class HermesMessage {
    public static final String SCHEMA_VERSION_HEADER = "Schema-Version";
    static final String APPLICATION_JSON = "application/json;charset=UTF-8";
    static final String CONTENT_TYPE_HEADER = "Content-Type";
    static final String AVRO_BINARY = "avro/binary";
    private final String topic;
    private final byte[] body;
    private final Map<String, String> headers;

    private HermesMessage(String topic, Map<String, String> headers, byte[] body) {
        this.topic = topic;
        this.headers = headers;
        this.body = body;
    }

    @Deprecated
    public HermesMessage(String topic, String contentType, int schemaVersion, byte[] body) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(CONTENT_TYPE_HEADER, contentType);
        headers.put(SCHEMA_VERSION_HEADER, Integer.toString(schemaVersion));
        this.topic = topic;
        this.headers = headers;
        this.body = body;
    }

    @Deprecated
    public HermesMessage(String topic, String contentType, byte[] body) {
        this(topic, contentType, -1, body);
    }

    @Deprecated
    public HermesMessage(String topic, String contentType, String body) {
        this(topic, contentType, body.getBytes(StandardCharsets.UTF_8));
    }

    @Deprecated
    public HermesMessage(String topic, String body) {
        this(topic, null, body);
    }

    public static Builder hermesMessage(String topic, byte[] content) {
        return new Builder(topic, content);
    }

    public static Builder hermesMessage(String topic, String content) {
        return new Builder(topic, content);
    }

    static HermesMessage appendDefaults(HermesMessage message, Map<String, String> headers) {
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            if (message.headers.containsKey(entry.getKey())) continue;
            message.headers.put(entry.getKey(), entry.getValue());
        }
        return message;
    }

    public String getTopic() {
        return this.topic;
    }

    public byte[] getBody() {
        return this.body;
    }

    public String getContentType() {
        return this.headers.get(CONTENT_TYPE_HEADER);
    }

    public int getSchemaVersion() {
        String schemaVersion = this.headers.get(SCHEMA_VERSION_HEADER);
        return schemaVersion != null ? Integer.parseInt(schemaVersion) : -1;
    }

    public boolean schemaVersionDefined() {
        return this.headers.containsKey(SCHEMA_VERSION_HEADER);
    }

    public Map<String, String> getHeaders() {
        return Collections.unmodifiableMap(this.headers);
    }

    public void consumeHeaders(BiConsumer<String, String> consumer) {
        this.headers.forEach(consumer);
    }

    public String toString() {
        return new String(this.getBody(), StandardCharsets.UTF_8);
    }

    public static class Builder {
        private final String topic;
        private final byte[] body;
        private final Map<String, String> headers = new HashMap<String, String>();

        private Builder(String topic, byte[] body) {
            this.topic = topic;
            this.body = body;
        }

        private Builder(String topic, String body) {
            this(topic, body.getBytes(StandardCharsets.UTF_8));
        }

        public HermesMessage build() {
            return new HermesMessage(this.topic, this.headers, this.body);
        }

        public Builder json() {
            this.withContentType(HermesMessage.APPLICATION_JSON);
            return this;
        }

        public Builder avro(int schemaVersion) {
            this.withContentType(HermesMessage.AVRO_BINARY);
            this.withSchemaVersion(schemaVersion);
            return this;
        }

        public Builder withContentType(String contentType) {
            this.headers.put(HermesMessage.CONTENT_TYPE_HEADER, contentType);
            return this;
        }

        public Builder withSchemaVersion(int schemaVersion) {
            this.headers.put(HermesMessage.SCHEMA_VERSION_HEADER, Integer.toString(schemaVersion));
            return this;
        }

        public Builder withHeader(String header, String value) {
            this.headers.put(header, value);
            return this;
        }
    }
}

