/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.client.metrics;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.net.URI;
import java.util.concurrent.CompletableFuture;
import pl.allegro.tech.hermes.client.HermesMessage;
import pl.allegro.tech.hermes.client.HermesResponse;
import pl.allegro.tech.hermes.client.HermesSender;

public class MetricsHermesSender
implements HermesSender {
    private final HermesSender sender;
    private final MetricRegistry metrics;

    public MetricsHermesSender(HermesSender sender, MetricRegistry metrics) {
        this.sender = sender;
        this.metrics = metrics;
    }

    @Override
    public CompletableFuture<HermesResponse> send(URI uri, HermesMessage message) {
        String prefix = "hermes-client." + this.sanitizeTopic(message.getTopic());
        Timer.Context ctx = this.metrics.timer(prefix + ".latency").time();
        return this.sender.send(uri, message).whenComplete((resp, cause) -> {
            ctx.close();
            if (resp != null) {
                this.metrics.counter(prefix + ".status." + resp.getHttpStatus()).inc();
            }
            if (cause != null) {
                this.metrics.counter(prefix + ".failure").inc();
            }
        });
    }

    private String sanitizeTopic(String topic) {
        int lastDot = topic.lastIndexOf(".");
        char[] sanitized = topic.replaceAll("\\.", "_").toCharArray();
        sanitized[lastDot] = 46;
        return String.valueOf(sanitized);
    }
}

