/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.client;

import java.util.function.Predicate;
import pl.allegro.tech.hermes.client.HermesResponse;

public class HermesClientBasicRetryCondition
implements Predicate<HermesResponse> {
    @Override
    public boolean test(HermesResponse response) {
        return response == null || this.isClientTimeoutOrServerError(response) || this.isFailedExceptionally(response);
    }

    private boolean isClientTimeoutOrServerError(HermesResponse response) {
        return response.getHttpStatus() == 408 || response.getHttpStatus() / 100 == 5;
    }

    private boolean isFailedExceptionally(HermesResponse response) {
        return response.isFailure() && response.getFailureCause().isPresent();
    }
}

