/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.client.metrics;

import com.codahale.metrics.MetricRegistry;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import pl.allegro.tech.hermes.client.metrics.MetricsProvider;

public class DropwizardMetricsProvider
implements MetricsProvider {
    private final MetricRegistry metrics;

    public DropwizardMetricsProvider(MetricRegistry metrics) {
        this.metrics = metrics;
    }

    @Override
    public void counterIncrement(String name) {
        this.metrics.counter(name).inc();
    }

    @Override
    public void counterIncrement(String prefix, String name, Map<String, String> tags) {
        this.counterIncrement(this.buildCounterName(prefix, name, tags));
    }

    @Override
    public void timerRecord(String name, long duration, TimeUnit unit) {
        this.metrics.timer(name).update(duration, unit);
    }

    @Override
    public void histogramUpdate(String name, int value) {
        this.metrics.histogram(name).update(value);
    }

    private String buildCounterName(String prefix, String name, Map<String, String> tags) {
        return prefix + "." + name + "." + String.join((CharSequence)".", tags.values());
    }
}

