/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.client.metrics;

import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import pl.allegro.tech.hermes.client.metrics.MetricsProvider;

public class MicrometerMetricsProvider
implements MetricsProvider {
    private final MeterRegistry metrics;

    public MicrometerMetricsProvider(MeterRegistry metrics) {
        this.metrics = metrics;
    }

    @Override
    public void counterIncrement(String name) {
        this.metrics.counter(name, new String[0]).increment();
    }

    @Override
    public void counterIncrement(String prefix, String name, Map<String, String> tags) {
        this.metrics.counter(this.buildCounterName(prefix, name, tags), (Iterable)Tags.of((Iterable)tags.entrySet().stream().map(e -> Tag.of((String)((String)e.getKey()), (String)((String)e.getValue()))).collect(Collectors.toSet()))).increment();
    }

    @Override
    public void timerRecord(String name, long duration, TimeUnit unit) {
        this.metrics.timer(name, new String[0]).record(duration, unit);
    }

    @Override
    public void histogramUpdate(String name, int value) {
        DistributionSummary.builder((String)name).publishPercentiles(new double[]{0.0, 0.5, 0.9, 0.95, 0.99}).register(this.metrics).record((double)value);
    }

    private String buildCounterName(String prefix, String name, Map<String, String> tags) {
        return prefix + "." + name + "." + tags.keySet().stream().map(e -> "{" + e + "}").collect(Collectors.joining("."));
    }
}

