/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.client;

import java.util.Optional;
import pl.allegro.tech.hermes.client.HermesMessage;

public interface HermesResponse {
    public static final String MESSAGE_ID = "Hermes-Message-Id";
    public static final String HTTP_1_1 = "http/1.1";

    public int getHttpStatus();

    public HermesMessage getHermesMessage();

    @Deprecated
    default public boolean wasPublished() {
        return this.getHttpStatus() == 201;
    }

    @Deprecated
    default public boolean wasAccepted() {
        return this.wasPublished() || this.getHttpStatus() == 202;
    }

    default public boolean isSuccess() {
        return this.getHttpStatus() == 201 || this.getHttpStatus() == 202;
    }

    default public boolean isFailure() {
        return !this.isSuccess();
    }

    default public Optional<Throwable> getFailureCause() {
        return Optional.empty();
    }

    @Deprecated
    default public Optional<HermesMessage> getFailedMessage() {
        return Optional.empty();
    }

    default public String getBody() {
        return "";
    }

    default public String getHeader(String header) {
        return "";
    }

    default public String getMessageId() {
        return this.getHeader(MESSAGE_ID);
    }

    default public String getProtocol() {
        return HTTP_1_1;
    }

    default public String getDebugLog() {
        StringBuilder builder = new StringBuilder("Sending message ").append(this.getMessageId()).append(" to Hermes ").append(this.isSuccess() ? "succeeded" : "failed").append(", response code: ").append(this.getHttpStatus()).append(", body: ").append(this.getBody());
        this.getFailureCause().ifPresent(ex -> builder.append(", exception: ").append(ex.getMessage()));
        return builder.toString();
    }
}

