/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.client.metrics;

import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import pl.allegro.tech.hermes.client.HermesMessage;
import pl.allegro.tech.hermes.client.HermesResponse;
import pl.allegro.tech.hermes.client.MessageDeliveryListener;
import pl.allegro.tech.hermes.client.metrics.MetricsProvider;
import pl.allegro.tech.hermes.client.metrics.MetricsUtils;

public class MetricsMessageDeliveryListener
implements MessageDeliveryListener {
    private final MetricsProvider metrics;

    public MetricsMessageDeliveryListener(MetricsProvider metrics) {
        this.metrics = metrics;
    }

    @Override
    public void onSend(HermesResponse response, long latency) {
        HermesMessage message = response.getHermesMessage();
        String prefix = MetricsUtils.getMetricsPrefix(message.getTopic());
        this.metrics.timerRecord(prefix + ".latency", latency, TimeUnit.NANOSECONDS);
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("code", String.valueOf(response.getHttpStatus()));
        this.metrics.counterIncrement(prefix, "status", tags);
    }

    @Override
    public void onFailure(HermesMessage message, int attemptCount) {
        String prefix = MetricsUtils.getMetricsPrefix(message.getTopic());
        this.metrics.counterIncrement(prefix + ".failure");
    }

    @Override
    public void onFailedRetry(HermesMessage message, int attemptCount) {
        String prefix = MetricsUtils.getMetricsPrefix(message.getTopic());
        this.metrics.counterIncrement(prefix + ".retries.count");
        this.metrics.counterIncrement(prefix + ".failure");
    }

    @Override
    public void onSuccessfulRetry(HermesMessage message, int attemptCount) {
        String prefix = MetricsUtils.getMetricsPrefix(message.getTopic());
        this.metrics.counterIncrement(prefix + ".retries.success");
        this.metrics.histogramUpdate(prefix + ".retries.attempts", attemptCount - 1);
    }

    @Override
    public void onMaxRetriesExceeded(HermesMessage message, int attemptCount) {
        String prefix = MetricsUtils.getMetricsPrefix(message.getTopic());
        this.metrics.counterIncrement(prefix + ".retries.exhausted");
    }
}

