/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.client.metrics;

import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import pl.allegro.tech.hermes.client.HermesMessage;
import pl.allegro.tech.hermes.client.HermesResponse;
import pl.allegro.tech.hermes.client.MessageDeliveryListener;
import pl.allegro.tech.hermes.client.metrics.MetricsProvider;
import pl.allegro.tech.hermes.client.metrics.MetricsUtils;

public class MetricsMessageDeliveryListener
implements MessageDeliveryListener {
    private final MetricsProvider metrics;

    public MetricsMessageDeliveryListener(MetricsProvider metrics) {
        this.metrics = metrics;
    }

    @Override
    public void onSend(HermesResponse response, long latency) {
        HermesMessage message = response.getHermesMessage();
        String prefix = MetricsUtils.getMetricsPrefix(message.getTopic());
        this.metrics.timerRecord(prefix + ".latency", latency, TimeUnit.NANOSECONDS);
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("code", String.valueOf(response.getHttpStatus()));
        this.metrics.counterIncrement(prefix, "status", tags);
        this.counterIncrementIf(prefix + ".publish.failure", response.isFailure());
    }

    @Override
    public void onFailure(HermesResponse response, int attemptCount) {
        String prefix = MetricsUtils.getMetricsPrefix(response.getHermesMessage().getTopic());
        this.metrics.counterIncrement(prefix + ".failure");
    }

    @Override
    public void onFailedRetry(HermesResponse response, int attemptCount) {
        String prefix = MetricsUtils.getMetricsPrefix(response.getHermesMessage().getTopic());
        this.metrics.counterIncrement(prefix + ".retries.count");
        this.metrics.counterIncrement(prefix + ".failure");
        this.metrics.counterIncrement(prefix + ".publish.retry.failure");
    }

    @Override
    public void onSuccessfulRetry(HermesResponse response, int attemptCount) {
        String prefix = MetricsUtils.getMetricsPrefix(response.getHermesMessage().getTopic());
        this.metrics.counterIncrement(prefix + ".retries.success");
        this.metrics.histogramUpdate(prefix + ".retries.attempts", attemptCount - 1);
        boolean wasRetried = attemptCount > 1;
        this.metrics.counterIncrement(prefix + ".publish.attempt");
        this.counterIncrementIf(prefix + ".publish.retry.success", response.isSuccess() && wasRetried);
        this.counterIncrementIf(prefix + ".publish.finally.success", response.isSuccess());
        this.counterIncrementIf(prefix + ".publish.retry.failure", response.isFailure() && wasRetried);
        this.counterIncrementIf(prefix + ".publish.finally.failure", response.isFailure());
        this.counterIncrementIf(prefix + ".publish.retry.attempt", wasRetried);
    }

    @Override
    public void onMaxRetriesExceeded(HermesResponse response, int attemptCount) {
        String prefix = MetricsUtils.getMetricsPrefix(response.getHermesMessage().getTopic());
        this.metrics.counterIncrement(prefix + ".retries.exhausted");
        this.metrics.counterIncrement(prefix + ".publish.finally.failure");
        this.metrics.counterIncrement(prefix + ".publish.attempt");
        this.metrics.counterIncrement(prefix + ".publish.retry.attempt");
    }

    private void counterIncrementIf(String name, boolean condition) {
        if (condition) {
            this.metrics.counterIncrement(name);
        }
    }
}

