/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.client;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.function.Predicate;
import java.util.function.Supplier;
import pl.allegro.tech.hermes.client.HermesClientBasicRetryCondition;
import pl.allegro.tech.hermes.client.HermesResponse;
import pl.allegro.tech.hermes.client.ReactiveHermesClient;
import pl.allegro.tech.hermes.client.ReactiveHermesSender;
import pl.allegro.tech.hermes.client.metrics.MetricsMessageDeliveryListener;
import pl.allegro.tech.hermes.client.metrics.MetricsProvider;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

public class ReactiveHermesClientBuilder {
    private ReactiveHermesSender sender;
    private URI uri = URI.create("http://localhost:8080");
    private final Map<String, String> defaultHeaders = new HashMap<String, String>();
    private int retries = 3;
    private Predicate<HermesResponse> retryCondition = new HermesClientBasicRetryCondition();
    private long retrySleepInMillis = 100L;
    private long maxRetrySleepInMillis = 300L;
    private double jitterFactor = 0.5;
    private Supplier<Scheduler> schedulerFactory = () -> Schedulers.fromExecutor((Executor)Executors.newSingleThreadScheduledExecutor());
    private Optional<MetricsProvider> metrics = Optional.empty();

    public ReactiveHermesClientBuilder(ReactiveHermesSender sender) {
        this.sender = sender;
        this.defaultHeaders.put("Content-Type", "application/json;charset=UTF-8");
    }

    public static ReactiveHermesClientBuilder hermesClient(ReactiveHermesSender sender) {
        return new ReactiveHermesClientBuilder(sender);
    }

    public ReactiveHermesClient build() {
        ReactiveHermesClient hermesClient = new ReactiveHermesClient(this.sender, this.uri, this.defaultHeaders, this.retries, this.retryCondition, this.retrySleepInMillis, this.maxRetrySleepInMillis, this.jitterFactor, this.schedulerFactory.get());
        this.metrics.ifPresent(metricsProvider -> hermesClient.addMessageDeliveryListener(new MetricsMessageDeliveryListener((MetricsProvider)metricsProvider)));
        return hermesClient;
    }

    public ReactiveHermesClientBuilder withURI(URI uri) {
        this.uri = uri;
        return this;
    }

    public ReactiveHermesClientBuilder withMetrics(MetricsProvider metrics) {
        this.metrics = Optional.of(metrics);
        return this;
    }

    public ReactiveHermesClientBuilder withDefaultContentType(String defaultContentType) {
        this.defaultHeaders.put("Content-Type", defaultContentType);
        return this;
    }

    public ReactiveHermesClientBuilder withDefaultHeaderValue(String header, String value) {
        this.defaultHeaders.put(header, value);
        return this;
    }

    public ReactiveHermesClientBuilder withRetries(int retries) {
        this.retries = retries;
        return this;
    }

    public ReactiveHermesClientBuilder withRetries(int retries, Predicate<HermesResponse> retryCondition) {
        this.retryCondition = retryCondition;
        return this.withRetries(retries);
    }

    public ReactiveHermesClientBuilder withRetrySleep(long retrySleepInMillis) {
        this.retrySleepInMillis = retrySleepInMillis;
        return this;
    }

    public ReactiveHermesClientBuilder withRetrySleep(long retrySleepInMillis, long maxRetrySleepInMillis) {
        this.retrySleepInMillis = retrySleepInMillis;
        this.maxRetrySleepInMillis = maxRetrySleepInMillis;
        return this;
    }

    public ReactiveHermesClientBuilder withScheduler(Scheduler scheduler) {
        this.schedulerFactory = () -> scheduler;
        return this;
    }

    public ReactiveHermesClientBuilder withJitter(Double jitterFactor) {
        this.jitterFactor = jitterFactor;
        return this;
    }
}

