/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.client;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.BooleanSupplier;

class HermesClientTermination {
    private final ExecutorService executorService = Executors.newSingleThreadExecutor();
    private final long pollInterval;

    HermesClientTermination(long pollInterval) {
        this.pollInterval = pollInterval;
    }

    CompletableFuture<Void> observe(BooleanSupplier condition) {
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        this.executorService.submit(() -> {
            try {
                while (!condition.getAsBoolean()) {
                    Thread.sleep(this.pollInterval);
                }
                result.complete(null);
            }
            catch (InterruptedException e) {
                result.completeExceptionally(e);
                Thread.currentThread().interrupt();
            }
            finally {
                this.executorService.shutdown();
            }
        });
        return result;
    }
}

