/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.client.metrics;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import pl.allegro.tech.hermes.client.metrics.MetricsProvider;

public class MicrometerTaggedMetricsProvider
implements MetricsProvider {
    private final MeterRegistry metrics;

    public MicrometerTaggedMetricsProvider(MeterRegistry metrics) {
        this.metrics = metrics;
    }

    @Override
    public void counterIncrement(String topic, String key) {
        this.counterIncrement(topic, key, new HashMap<String, String>());
    }

    @Override
    public void counterIncrement(String topic, String key, Map<String, String> tags) {
        tags.put("topic", topic);
        this.metrics.counter(this.buildCounterName(key), (Iterable)Tags.of((Iterable)tags.entrySet().stream().map(e -> Tag.of((String)((String)e.getKey()), (String)((String)e.getValue()))).collect(Collectors.toSet()))).increment();
    }

    @Override
    public void timerRecord(String topic, String key, long duration, TimeUnit unit) {
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("topic", topic);
        this.metrics.timer(this.buildCounterName(key), (Iterable)Tags.of((Iterable)tags.entrySet().stream().map(e -> Tag.of((String)((String)e.getKey()), (String)((String)e.getValue()))).collect(Collectors.toSet()))).record(duration, unit);
    }

    @Override
    public void histogramUpdate(String topic, String key, int value) {
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("topic", topic);
        this.metrics.summary(this.buildCounterName(key), (Iterable)Tags.of((Iterable)tags.entrySet().stream().map(e -> Tag.of((String)((String)e.getKey()), (String)((String)e.getValue()))).collect(Collectors.toSet()))).record((double)value);
    }

    private String buildCounterName(String key) {
        return "hermes-client." + key;
    }
}

