/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.client.metrics;

import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import pl.allegro.tech.hermes.client.HermesMessage;
import pl.allegro.tech.hermes.client.HermesResponse;
import pl.allegro.tech.hermes.client.MessageDeliveryListener;
import pl.allegro.tech.hermes.client.metrics.MetricsProvider;
import pl.allegro.tech.hermes.client.metrics.MetricsUtils;

public class MetricsMessageDeliveryListener
implements MessageDeliveryListener {
    private final MetricsProvider metrics;

    public MetricsMessageDeliveryListener(MetricsProvider metrics) {
        this.metrics = metrics;
    }

    @Override
    public void onSend(HermesResponse response, long latency) {
        HermesMessage message = response.getHermesMessage();
        String topic = MetricsUtils.sanitizeTopic(message.getTopic());
        this.metrics.timerRecord(topic, "latency", latency, TimeUnit.NANOSECONDS);
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("code", String.valueOf(response.getHttpStatus()));
        this.metrics.counterIncrement(topic, "status", tags);
        this.counterIncrementIf(topic, "publish.failure", response.isFailure());
    }

    @Override
    public void onFailure(HermesResponse response, int attemptCount) {
        String topic = MetricsUtils.sanitizeTopic(response.getHermesMessage().getTopic());
        this.metrics.counterIncrement(topic, "failure");
    }

    @Override
    public void onFailedRetry(HermesResponse response, int attemptCount) {
        String topic = MetricsUtils.sanitizeTopic(response.getHermesMessage().getTopic());
        this.metrics.counterIncrement(topic, "retries.count");
        this.metrics.counterIncrement(topic, "failure");
        this.metrics.counterIncrement(topic, "publish.retry.failure");
    }

    @Override
    public void onSuccessfulRetry(HermesResponse response, int attemptCount) {
        String topic = MetricsUtils.sanitizeTopic(response.getHermesMessage().getTopic());
        this.metrics.counterIncrement(topic, "retries.success");
        this.metrics.histogramUpdate(topic, "retries.attempts", attemptCount - 1);
        boolean wasRetried = attemptCount > 1;
        this.metrics.counterIncrement(topic, "publish.attempt");
        this.counterIncrementIf(topic, "publish.retry.success", response.isSuccess() && wasRetried);
        this.counterIncrementIf(topic, "publish.finally.success", response.isSuccess());
        this.counterIncrementIf(topic, "publish.retry.failure", response.isFailure() && wasRetried);
        this.counterIncrementIf(topic, "publish.finally.failure", response.isFailure());
        this.counterIncrementIf(topic, "publish.retry.attempt", wasRetried);
    }

    @Override
    public void onMaxRetriesExceeded(HermesResponse response, int attemptCount) {
        String topic = MetricsUtils.sanitizeTopic(response.getHermesMessage().getTopic());
        this.metrics.counterIncrement(topic, "retries.exhausted");
        this.metrics.counterIncrement(topic, "publish.finally.failure");
        this.metrics.counterIncrement(topic, "publish.attempt");
        this.metrics.counterIncrement(topic, "publish.retry.attempt");
    }

    private void counterIncrementIf(String topic, String name, boolean condition) {
        if (condition) {
            this.metrics.counterIncrement(topic, name);
        }
    }
}

