/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.client.metrics;

import com.codahale.metrics.MetricRegistry;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import pl.allegro.tech.hermes.client.metrics.MetricsProvider;

public class DropwizardMetricsProvider
implements MetricsProvider {
    private final MetricRegistry metrics;

    public DropwizardMetricsProvider(MetricRegistry metrics) {
        this.metrics = metrics;
    }

    @Override
    public void counterIncrement(String topic, String key) {
        this.metrics.counter("hermes-client." + topic + "." + key).inc();
    }

    @Override
    public void counterIncrement(String topic, String key, Map<String, String> tags) {
        this.counterIncrement(topic, this.buildCounterName(key, tags));
    }

    @Override
    public void timerRecord(String topic, String key, long duration, TimeUnit unit) {
        this.metrics.timer("hermes-client." + topic + "." + key).update(duration, unit);
    }

    @Override
    public void histogramUpdate(String topic, String key, int value) {
        this.metrics.histogram("hermes-client." + topic + "." + key).update(value);
    }

    private String buildCounterName(String key, Map<String, String> tags) {
        return key + "." + String.join((CharSequence)".", tags.values());
    }
}

