/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.client.jersey;

import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.InvocationCallback;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.util.concurrent.CompletableFuture;
import pl.allegro.tech.hermes.client.HermesMessage;
import pl.allegro.tech.hermes.client.HermesResponse;
import pl.allegro.tech.hermes.client.HermesResponseBuilder;
import pl.allegro.tech.hermes.client.HermesSender;

public class JerseyHermesSender
implements HermesSender {
    private final Client client;

    public JerseyHermesSender(Client client) {
        this.client = client;
    }

    @Override
    public CompletableFuture<HermesResponse> send(URI uri, final HermesMessage message) {
        final CompletableFuture<HermesResponse> future = new CompletableFuture<HermesResponse>();
        Invocation.Builder builder = this.client.target(uri).request();
        message.consumeHeaders((arg_0, arg_1) -> ((Invocation.Builder)builder).header(arg_0, arg_1));
        builder.async().post(Entity.entity((Object)message.getBody(), (String)message.getContentType()), (InvocationCallback)new InvocationCallback<Response>(){

            public void completed(Response response) {
                future.complete(JerseyHermesSender.this.fromJerseyResponse(message, response));
            }

            public void failed(Throwable exception) {
                future.completeExceptionally(exception);
            }
        });
        return future;
    }

    private HermesResponse fromJerseyResponse(HermesMessage message, Response response) {
        return HermesResponseBuilder.hermesResponse(message).withHttpStatus(response.getStatus()).withBody((String)response.readEntity(String.class)).withHeaderSupplier(arg_0 -> ((Response)response).getHeaderString(arg_0)).build();
    }
}

