/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.rate.calculator;

import java.util.EnumMap;
import java.util.Map;
import javax.inject.Inject;
import pl.allegro.tech.hermes.api.Subscription;
import pl.allegro.tech.hermes.common.config.ConfigFactory;
import pl.allegro.tech.hermes.common.config.Configs;
import pl.allegro.tech.hermes.consumers.consumer.ActiveConsumerCounter;
import pl.allegro.tech.hermes.consumers.consumer.rate.DeliveryCounters;
import pl.allegro.tech.hermes.consumers.consumer.rate.calculator.HeartbeatModeOutputRateCalculator;
import pl.allegro.tech.hermes.consumers.consumer.rate.calculator.MaximumOutputRateCalculator;
import pl.allegro.tech.hermes.consumers.consumer.rate.calculator.ModeOutputRateCalculator;
import pl.allegro.tech.hermes.consumers.consumer.rate.calculator.NormalModeOutputRateCalculator;
import pl.allegro.tech.hermes.consumers.consumer.rate.calculator.OutputRateCalculationResult;
import pl.allegro.tech.hermes.consumers.consumer.rate.calculator.SlowModeOutputRateCalculator;

public class OutputRateCalculator {
    private final Map<Mode, ModeOutputRateCalculator> modeCalculators = new EnumMap<Mode, ModeOutputRateCalculator>(Mode.class);
    private final MaximumOutputRateCalculator maximumRateCalculator;

    @Inject
    public OutputRateCalculator(ConfigFactory configFactory, ActiveConsumerCounter activeConsumerCounter) {
        this.modeCalculators.put(Mode.NORMAL, new NormalModeOutputRateCalculator(configFactory.getDoubleProperty(Configs.CONSUMER_RATE_CONVERGENCE_FACTOR), 1.0 / (double)configFactory.getIntProperty(Configs.CONSUMER_RATE_LIMITER_SLOW_MODE_DELAY), configFactory.getDoubleProperty(Configs.CONSUMER_RATE_FAILURES_SPEEDUP_TOLERANCE_RATIO), configFactory.getDoubleProperty(Configs.CONSUMER_RATE_FAILURES_NOCHANGE_TOLERANCE_RATIO)));
        this.modeCalculators.put(Mode.SLOW, new SlowModeOutputRateCalculator(1.0 / (double)configFactory.getIntProperty(Configs.CONSUMER_RATE_LIMITER_HEARTBEAT_MODE_DELAY)));
        this.modeCalculators.put(Mode.HEARTBEAT, new HeartbeatModeOutputRateCalculator(1.0 / (double)configFactory.getIntProperty(Configs.CONSUMER_RATE_LIMITER_SLOW_MODE_DELAY)));
        this.maximumRateCalculator = new MaximumOutputRateCalculator(activeConsumerCounter);
    }

    public OutputRateCalculationResult recalculateRate(Subscription subscription, DeliveryCounters counters, Mode currentMode, double currentRate) {
        double maximumRate = this.maximumRateCalculator.calculateMaximumOutputRate(subscription);
        OutputRateCalculationResult recalculatedResult = this.modeCalculators.get((Object)currentMode).calculateOutputRate(currentRate, maximumRate, counters);
        if (recalculatedResult.rate() > maximumRate) {
            recalculatedResult = OutputRateCalculationResult.adjustRate(recalculatedResult, maximumRate);
        }
        return recalculatedResult;
    }

    public static enum Mode {
        NORMAL,
        SLOW,
        HEARTBEAT;

    }
}

