/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.supervisor.workload;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import pl.allegro.tech.hermes.api.SubscriptionName;
import pl.allegro.tech.hermes.consumers.supervisor.workload.SubscriptionAssignment;

public class SubscriptionAssignmentView {
    private final Map<SubscriptionName, Set<SubscriptionAssignment>> subscriptionAssignments;
    private final Map<String, Set<SubscriptionAssignment>> consumerNodeAssignments;

    public SubscriptionAssignmentView(Map<SubscriptionName, Set<SubscriptionAssignment>> view) {
        this.subscriptionAssignments = this.setupSubscriptionAssignments(view);
        this.consumerNodeAssignments = this.setupConsumerNodeAssignments(view);
    }

    private Map<SubscriptionName, Set<SubscriptionAssignment>> setupSubscriptionAssignments(Map<SubscriptionName, Set<SubscriptionAssignment>> view) {
        HashMap<SubscriptionName, Set<SubscriptionAssignment>> map = new HashMap<SubscriptionName, Set<SubscriptionAssignment>>();
        view.entrySet().stream().forEach(entry -> {
            Set cfr_ignored_0 = map.put((SubscriptionName)entry.getKey(), new HashSet((Collection)entry.getValue()));
        });
        return map;
    }

    private Map<String, Set<SubscriptionAssignment>> setupConsumerNodeAssignments(Map<SubscriptionName, Set<SubscriptionAssignment>> view) {
        HashMap<String, Set<SubscriptionAssignment>> map = new HashMap<String, Set<SubscriptionAssignment>>();
        view.values().stream().flatMap(Collection::stream).forEach(assignment -> {
            if (!map.containsKey(assignment.getConsumerNodeId())) {
                map.put(assignment.getConsumerNodeId(), new HashSet());
            }
            ((Set)map.get(assignment.getConsumerNodeId())).add(assignment);
        });
        return map;
    }

    public Set<SubscriptionName> getSubscriptions() {
        return ImmutableSet.copyOf(this.subscriptionAssignments.keySet());
    }

    public int getSubscriptionsCount() {
        return this.subscriptionAssignments.size();
    }

    public Set<String> getConsumerNodes() {
        return ImmutableSet.copyOf(this.consumerNodeAssignments.keySet());
    }

    public List<SubscriptionAssignment> getAllAssignments() {
        return this.subscriptionAssignments.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    public Set<String> getConsumerNodesForSubscription(SubscriptionName subscriptionName) {
        return this.getAssignmentsForSubscription(subscriptionName).stream().map(SubscriptionAssignment::getConsumerNodeId).collect(Collectors.toSet());
    }

    public Set<SubscriptionAssignment> getAssignmentsForSubscription(SubscriptionName subscriptionName) {
        return Collections.unmodifiableSet(this.subscriptionAssignments.getOrDefault(subscriptionName, Collections.emptySet()));
    }

    public Set<SubscriptionName> getSubscriptionsForConsumerNode(String nodeId) {
        return this.getAssignmentsForConsumerNode(nodeId).stream().map(SubscriptionAssignment::getSubscriptionName).collect(Collectors.toSet());
    }

    public Set<SubscriptionAssignment> getAssignmentsForConsumerNode(String nodeId) {
        return Collections.unmodifiableSet(this.consumerNodeAssignments.getOrDefault(nodeId, Collections.emptySet()));
    }

    private void removeSubscription(SubscriptionName subscription) {
        this.consumerNodeAssignments.values().stream().forEach(assignments -> assignments.removeIf(assignment -> assignment.getSubscriptionName().equals((Object)subscription)));
        this.subscriptionAssignments.remove(subscription);
    }

    private void removeConsumerNode(String nodeId) {
        this.subscriptionAssignments.values().stream().forEach(assignments -> assignments.removeIf(assignment -> assignment.getConsumerNodeId().equals(nodeId)));
        this.consumerNodeAssignments.remove(nodeId);
    }

    private void addSubscription(SubscriptionName subscriptionName) {
        this.subscriptionAssignments.putIfAbsent(subscriptionName, new HashSet());
    }

    private void addConsumerNode(String nodeId) {
        this.consumerNodeAssignments.putIfAbsent(nodeId, new HashSet());
    }

    private void addAssignment(SubscriptionAssignment assignment) {
        this.subscriptionAssignments.get(assignment.getSubscriptionName()).add(assignment);
        this.consumerNodeAssignments.get(assignment.getConsumerNodeId()).add(assignment);
    }

    private void removeAssignment(SubscriptionAssignment assignment) {
        this.subscriptionAssignments.get(assignment.getSubscriptionName()).remove(assignment);
        this.consumerNodeAssignments.get(assignment.getConsumerNodeId()).remove(assignment);
    }

    private void transferAssignment(String from, String to, SubscriptionName subscriptionName) {
        this.removeAssignment(new SubscriptionAssignment(from, subscriptionName));
        this.addAssignment(new SubscriptionAssignment(to, subscriptionName));
    }

    public SubscriptionAssignmentView deletions(SubscriptionAssignmentView target) {
        return SubscriptionAssignmentView.difference(this, target);
    }

    public SubscriptionAssignmentView additions(SubscriptionAssignmentView target) {
        return SubscriptionAssignmentView.difference(target, this);
    }

    private static SubscriptionAssignmentView difference(SubscriptionAssignmentView first, SubscriptionAssignmentView second) {
        HashMap<SubscriptionName, Set<SubscriptionAssignment>> result = new HashMap<SubscriptionName, Set<SubscriptionAssignment>>();
        for (SubscriptionName subscription : first.getSubscriptions()) {
            Set<SubscriptionAssignment> assignments = first.getAssignmentsForSubscription(subscription);
            if (!second.getSubscriptions().contains(subscription)) {
                result.put(subscription, assignments);
                continue;
            }
            Sets.SetView difference = Sets.difference(assignments, second.getAssignmentsForSubscription(subscription));
            if (difference.isEmpty()) continue;
            result.put(subscription, (Set<SubscriptionAssignment>)difference);
        }
        return new SubscriptionAssignmentView(result);
    }

    public static SubscriptionAssignmentView copyOf(SubscriptionAssignmentView currentState) {
        return new SubscriptionAssignmentView(currentState.subscriptionAssignments);
    }

    public int getAssignmentsCountForSubscription(SubscriptionName subscription) {
        return this.subscriptionAssignments.get(subscription).size();
    }

    public int getAssignmentsCountForConsumerNode(String nodeId) {
        return this.consumerNodeAssignments.get(nodeId).size();
    }

    public int hashCode() {
        return Objects.hash(this.subscriptionAssignments);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubscriptionAssignmentView that = (SubscriptionAssignmentView)o;
        return Objects.equals(this.subscriptionAssignments, that.subscriptionAssignments);
    }

    public SubscriptionAssignmentView transform(BiConsumer<SubscriptionAssignmentView, Transformer> consumer) {
        final SubscriptionAssignmentView view = SubscriptionAssignmentView.copyOf(this);
        consumer.accept(view, new Transformer(){

            @Override
            public void removeSubscription(SubscriptionName subscriptionName) {
                view.removeSubscription(subscriptionName);
            }

            @Override
            public void removeConsumerNode(String nodeId) {
                view.removeConsumerNode(nodeId);
            }

            @Override
            public void addSubscription(SubscriptionName subscriptionName) {
                view.addSubscription(subscriptionName);
            }

            @Override
            public void addConsumerNode(String nodeId) {
                view.addConsumerNode(nodeId);
            }

            @Override
            public void addAssignment(SubscriptionAssignment assignment) {
                view.addAssignment(assignment);
            }

            @Override
            public void transferAssignment(String from, String to, SubscriptionName subscriptionName) {
                view.transferAssignment(from, to, subscriptionName);
            }
        });
        return SubscriptionAssignmentView.copyOf(view);
    }

    public static interface Transformer {
        public void removeSubscription(SubscriptionName var1);

        public void removeConsumerNode(String var1);

        public void addSubscription(SubscriptionName var1);

        public void addConsumerNode(String var1);

        public void addAssignment(SubscriptionAssignment var1);

        public void transferAssignment(String var1, String var2, SubscriptionName var3);
    }
}

