/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.supervisor.workload.mirror;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.allegro.tech.hermes.api.Subscription;
import pl.allegro.tech.hermes.api.SubscriptionName;
import pl.allegro.tech.hermes.api.Topic;
import pl.allegro.tech.hermes.common.admin.AdminOperationsCallback;
import pl.allegro.tech.hermes.common.admin.zookeeper.ZookeeperAdminCache;
import pl.allegro.tech.hermes.common.config.ConfigFactory;
import pl.allegro.tech.hermes.common.config.Configs;
import pl.allegro.tech.hermes.consumers.subscription.cache.SubscriptionsCache;
import pl.allegro.tech.hermes.consumers.supervisor.ConsumersSupervisor;
import pl.allegro.tech.hermes.consumers.supervisor.workload.SubscriptionAssignmentRegistry;
import pl.allegro.tech.hermes.consumers.supervisor.workload.SupervisorController;
import pl.allegro.tech.hermes.consumers.supervisor.workload.WorkTracker;
import pl.allegro.tech.hermes.domain.notifications.InternalNotificationsBus;
import pl.allegro.tech.hermes.domain.notifications.SubscriptionCallback;
import pl.allegro.tech.hermes.domain.notifications.TopicCallback;

public class MirroringSupervisorController
implements SupervisorController {
    private static final Logger logger = LoggerFactory.getLogger(MirroringSupervisorController.class);
    private final String consumerNodeId;
    private final ConsumersSupervisor supervisor;
    private final InternalNotificationsBus notificationsBus;
    private final SubscriptionAssignmentRegistry assignementRegistry;
    private final SubscriptionsCache subscriptionsCache;
    private final WorkTracker workTracker;
    private final ZookeeperAdminCache adminCache;
    private final ConfigFactory configFactory;
    private final ExecutorService executorService;

    public MirroringSupervisorController(ConsumersSupervisor supervisor, InternalNotificationsBus notificationsBus, SubscriptionAssignmentRegistry assignementRegistry, SubscriptionsCache subscriptionsCache, WorkTracker workTracker, ZookeeperAdminCache adminCache, ConfigFactory configFactory) {
        this.consumerNodeId = configFactory.getStringProperty(Configs.CONSUMER_WORKLOAD_NODE_ID);
        this.supervisor = supervisor;
        this.notificationsBus = notificationsBus;
        this.assignementRegistry = assignementRegistry;
        this.subscriptionsCache = subscriptionsCache;
        this.workTracker = workTracker;
        this.adminCache = adminCache;
        this.configFactory = configFactory;
        this.executorService = Executors.newFixedThreadPool(configFactory.getIntProperty(Configs.ZOOKEEPER_TASK_PROCESSING_THREAD_POOL_SIZE), new ThreadFactoryBuilder().setNameFormat("mirroring-supervisor-%d").build());
    }

    public void onSubscriptionCreated(Subscription subscription) {
        this.executorService.submit(() -> this.workTracker.forceAssignment(subscription));
    }

    public void onSubscriptionRemoved(Subscription subscription) {
        this.executorService.submit(() -> this.workTracker.dropAssignment(subscription));
    }

    public void onSubscriptionChanged(Subscription subscription) {
        this.executorService.submit(() -> {
            switch (subscription.getState()) {
                case PENDING: 
                case ACTIVE: {
                    this.workTracker.forceAssignment(subscription);
                    break;
                }
                case SUSPENDED: {
                    this.workTracker.dropAssignment(subscription);
                    break;
                }
            }
            this.supervisor.updateSubscription(subscription);
        });
    }

    public void onTopicChanged(Topic topic) {
        for (Subscription subscription : this.subscriptionsCache.subscriptionsOfTopic(topic.getName())) {
            this.executorService.submit(() -> this.supervisor.updateTopic(subscription, topic));
        }
    }

    @Override
    public void onSubscriptionAssigned(Subscription subscription) {
        logger.info("Assigning consumer for {}", (Object)subscription.getQualifiedName());
        this.supervisor.assignConsumerForSubscription(subscription);
    }

    @Override
    public void onAssignmentRemoved(SubscriptionName subscription) {
        logger.info("Removing assignment from consumer for {}", (Object)subscription);
        this.supervisor.deleteConsumerForSubscriptionName(subscription);
    }

    @Override
    public void start() throws Exception {
        this.adminCache.start();
        this.adminCache.addCallback((AdminOperationsCallback)this);
        this.notificationsBus.registerSubscriptionCallback((SubscriptionCallback)this);
        this.notificationsBus.registerTopicCallback((TopicCallback)this);
        this.assignementRegistry.registerAssignementCallback(this);
        this.supervisor.start();
        this.assignementRegistry.start();
        logger.info("Consumer boot complete. Workload config: [{}]", (Object)this.configFactory.print(new Configs[]{Configs.CONSUMER_WORKLOAD_NODE_ID, Configs.CONSUMER_WORKLOAD_ALGORITHM}));
    }

    @Override
    public Set<SubscriptionName> assignedSubscriptions() {
        return this.assignementRegistry.createSnapshot().getSubscriptionsForConsumerNode(this.consumerNodeId);
    }

    @Override
    public void shutdown() throws InterruptedException {
        this.supervisor.shutdown();
    }

    public void onRetransmissionStarts(SubscriptionName subscription) throws Exception {
        this.supervisor.retransmit(subscription);
    }

    public void restartConsumer(SubscriptionName subscription) throws Exception {
        this.supervisor.restartConsumer(subscription);
    }
}

