/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.batch;

import com.google.common.base.Preconditions;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.concurrent.NotThreadSafe;
import pl.allegro.tech.hermes.api.ContentType;
import pl.allegro.tech.hermes.api.Header;
import pl.allegro.tech.hermes.api.Subscription;
import pl.allegro.tech.hermes.common.kafka.KafkaTopicName;
import pl.allegro.tech.hermes.common.kafka.offset.PartitionOffset;
import pl.allegro.tech.hermes.consumers.consumer.batch.MessageBatch;
import pl.allegro.tech.hermes.tracker.consumers.MessageMetadata;

@NotThreadSafe
public class JsonMessageBatch
implements MessageBatch {
    private final Clock clock;
    private final int maxBatchTime;
    private final int batchSize;
    private final String id;
    private final ByteBuffer byteBuffer;
    private final List<MessageMetadata> metadata = new ArrayList<MessageMetadata>();
    private final List<Header> additionalHeaders;
    private int elements = 0;
    private long batchStart;
    private boolean closed = false;
    private int retryCounter = 0;

    public JsonMessageBatch(String id, ByteBuffer buffer, int size, int batchTime, Clock clock, List<Header> additionalHeaders) {
        this.id = id;
        this.clock = clock;
        this.maxBatchTime = batchTime;
        this.batchSize = size;
        this.byteBuffer = buffer;
        this.additionalHeaders = additionalHeaders;
    }

    public JsonMessageBatch(String id, ByteBuffer buffer, Subscription subscription, Clock clock) {
        this(id, buffer, subscription.getBatchSubscriptionPolicy().getBatchSize(), subscription.getBatchSubscriptionPolicy().getBatchTime(), clock, subscription.getHeaders());
    }

    @Override
    public boolean isFull() {
        return this.elements >= this.batchSize || this.byteBuffer.remaining() < 2;
    }

    @Override
    public void append(byte[] data, MessageMetadata metadata) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Batch already closed.");
        if (!this.canFit(data)) {
            throw new BufferOverflowException();
        }
        if (this.isEmpty()) {
            this.batchStart = this.clock.millis();
        }
        this.byteBuffer.put((byte)(this.isEmpty() ? 91 : 44)).put(data);
        this.metadata.add(metadata);
        ++this.elements;
    }

    @Override
    public boolean canFit(byte[] data) {
        return this.byteBuffer.remaining() >= this.requiredFreeSpace(data);
    }

    private int requiredFreeSpace(byte[] data) {
        return data.length + 2;
    }

    @Override
    public boolean isExpired() {
        return !this.isEmpty() && this.getLifetime() > (long)this.maxBatchTime;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public ContentType getContentType() {
        return ContentType.JSON;
    }

    @Override
    public MessageBatch close() {
        if (!this.isEmpty()) {
            this.byteBuffer.put((byte)93);
        }
        int position = this.byteBuffer.position();
        this.byteBuffer.position(0);
        this.byteBuffer.limit(position);
        this.closed = true;
        return this;
    }

    @Override
    public ByteBuffer getContent() {
        if (this.closed) {
            this.byteBuffer.position(0);
        }
        return this.byteBuffer;
    }

    @Override
    public List<PartitionOffset> getPartitionOffsets() {
        return this.metadata.stream().map(m -> new PartitionOffset(KafkaTopicName.valueOf((String)m.getKafkaTopic()), m.getOffset(), m.getPartition())).collect(Collectors.toList());
    }

    @Override
    public List<MessageMetadata> getMessagesMetadata() {
        return Collections.unmodifiableList(this.metadata);
    }

    @Override
    public List<Header> getAdditionalHeaders() {
        return Collections.unmodifiableList(this.additionalHeaders);
    }

    @Override
    public int size() {
        return this.elements;
    }

    @Override
    public long getLifetime() {
        return this.clock.millis() - this.batchStart;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public boolean isEmpty() {
        return this.elements == 0;
    }

    @Override
    public boolean isBiggerThanTotalCapacity(byte[] data) {
        return this.requiredFreeSpace(data) > this.getCapacity();
    }

    @Override
    public int getCapacity() {
        return this.byteBuffer.capacity();
    }

    @Override
    public void incrementRetryCounter() {
        ++this.retryCounter;
    }

    @Override
    public int getRetryCounter() {
        return this.retryCounter;
    }
}

