/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.sender.http;

import java.io.File;
import java.net.CookieStore;
import java.security.KeyStore;
import java.util.Arrays;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.util.HttpCookieStore;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.glassfish.hk2.api.Factory;
import pl.allegro.tech.hermes.common.config.ConfigFactory;
import pl.allegro.tech.hermes.common.config.Configs;
import pl.allegro.tech.hermes.common.metric.executor.InstrumentedExecutorServiceFactory;

public class HttpClientFactory
implements Factory<HttpClient> {
    private final ConfigFactory configFactory;
    private final InstrumentedExecutorServiceFactory executorFactory;
    private final SslContextFactory sslContextFactory;

    @Inject
    public HttpClientFactory(ConfigFactory configFactory, InstrumentedExecutorServiceFactory executorFactory) {
        this.configFactory = configFactory;
        this.executorFactory = executorFactory;
        this.sslContextFactory = this.sslContextFactory(configFactory);
    }

    public HttpClient provide() {
        HttpClient client = new HttpClient(this.sslContextFactory);
        client.setMaxConnectionsPerDestination(this.configFactory.getIntProperty(Configs.CONSUMER_HTTP_CLIENT_MAX_CONNECTIONS_PER_DESTINATION));
        client.setMaxRequestsQueuedPerDestination(this.configFactory.getIntProperty(Configs.CONSUMER_INFLIGHT_SIZE));
        client.setExecutor((Executor)this.getExecutor());
        client.setCookieStore((CookieStore)new HttpCookieStore.Empty());
        return client;
    }

    private ExecutorService getExecutor() {
        return this.executorFactory.getExecutorService("jetty-http-client", this.configFactory.getIntProperty(Configs.CONSUMER_HTTP_CLIENT_THREAD_POOL_SIZE), this.configFactory.getBooleanProperty(Configs.CONSUMER_HTTP_CLIENT_THREAD_POOL_MONITORING));
    }

    public void dispose(HttpClient instance) {
    }

    private SslContextFactory sslContextFactory(ConfigFactory configFactory) {
        SslContextFactory sslContextFactory = new SslContextFactory();
        sslContextFactory.setValidateCerts(configFactory.getBooleanProperty(Configs.CONSUMER_HTTP_CLIENT_VALIDATE_CERTS));
        sslContextFactory.setValidatePeerCerts(configFactory.getBooleanProperty(Configs.CONSUMER_HTTP_CLIENT_VALIDATE_PEER_CERTS));
        sslContextFactory.setEnableCRLDP(configFactory.getBooleanProperty(Configs.CONSUMER_HTTP_CLIENT_ENABLE_CRLDP));
        sslContextFactory.setEndpointIdentificationAlgorithm("HTTPS");
        sslContextFactory.setTrustStorePath(System.getProperty("javax.net.ssl.trustStore", this.defaultTrustStorePath()));
        sslContextFactory.setTrustStoreType(System.getProperty("javax.net.ssl.trustStoreType", KeyStore.getDefaultType()));
        String password = System.getProperty("javax.net.ssl.trustStorePassword");
        if (password != null) {
            sslContextFactory.setTrustStorePassword(password);
        }
        return sslContextFactory;
    }

    private String defaultTrustStorePath() {
        return Arrays.asList(System.getProperty("java.home"), "lib", "security", "cacerts").stream().collect(Collectors.joining(File.separator));
    }
}

