/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.supervisor.process;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import pl.allegro.tech.hermes.api.SubscriptionName;
import pl.allegro.tech.hermes.consumers.supervisor.process.ConsumerProcess;
import pl.allegro.tech.hermes.consumers.supervisor.process.RunningSubscriptionStatus;

class RunningConsumerProcesses {
    private final Map<SubscriptionName, RunningProcess> processes = new ConcurrentHashMap<SubscriptionName, RunningProcess>();

    RunningConsumerProcesses() {
    }

    void add(ConsumerProcess process, Future executionHandle) {
        this.processes.put(process.getSubscriptionName(), new RunningProcess(process, executionHandle));
    }

    void remove(SubscriptionName subscriptionName) {
        this.processes.remove(subscriptionName);
    }

    Future getExecutionHandle(SubscriptionName subscriptionName) {
        return this.processes.get(subscriptionName).getExecutionHandle();
    }

    ConsumerProcess getProcess(SubscriptionName subscriptionName) {
        return this.processes.get((Object)subscriptionName).process;
    }

    boolean hasProcess(SubscriptionName subscriptionName) {
        return this.processes.containsKey(subscriptionName);
    }

    Stream<ConsumerProcess> stream() {
        return this.processes.values().stream().map(p -> p.process);
    }

    Set<SubscriptionName> existingConsumers() {
        return this.processes.keySet();
    }

    List<RunningSubscriptionStatus> listRunningSubscriptions() {
        return this.processes.entrySet().stream().map(entry -> new RunningSubscriptionStatus(((SubscriptionName)entry.getKey()).getQualifiedName(), ((RunningProcess)entry.getValue()).getProcess().getSignalTimesheet())).sorted((s1, s2) -> String.CASE_INSENSITIVE_ORDER.compare(s1.getQualifiedName(), s2.getQualifiedName())).collect(Collectors.toList());
    }

    Integer count() {
        return this.processes.size();
    }

    private static class RunningProcess {
        ConsumerProcess process;
        Future executionHandle;

        public RunningProcess(ConsumerProcess process, Future executionHandle) {
            this.process = process;
            this.executionHandle = executionHandle;
        }

        public ConsumerProcess getProcess() {
            return this.process;
        }

        public Future getExecutionHandle() {
            return this.executionHandle;
        }
    }
}

