/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.supervisor.workload;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import pl.allegro.tech.hermes.api.SubscriptionName;
import pl.allegro.tech.hermes.common.exception.InternalProcessingException;
import pl.allegro.tech.hermes.consumers.subscription.cache.SubscriptionsCache;
import pl.allegro.tech.hermes.consumers.supervisor.workload.SubscriptionAssignment;
import pl.allegro.tech.hermes.consumers.supervisor.workload.SubscriptionAssignmentAware;
import pl.allegro.tech.hermes.consumers.supervisor.workload.SubscriptionAssignmentPathSerializer;
import pl.allegro.tech.hermes.consumers.supervisor.workload.SubscriptionAssignmentView;
import pl.allegro.tech.hermes.infrastructure.zookeeper.cache.HierarchicalCache;

public class SubscriptionAssignmentRegistry {
    private static final int SUBSCRIPTION_LEVEL = 0;
    private static final int ASSIGNMENT_LEVEL = 1;
    private final Set<SubscriptionAssignment> assignments = Collections.newSetFromMap(new ConcurrentHashMap());
    private final String consumerNodeId;
    private final CuratorFramework curator;
    private final HierarchicalCache cache;
    private final SubscriptionsCache subscriptionsCache;
    private final SubscriptionAssignmentPathSerializer pathSerializer;

    public SubscriptionAssignmentRegistry(String consumerNodeId, CuratorFramework curator, String path, SubscriptionsCache subscriptionsCache, SubscriptionAssignmentPathSerializer pathSerializer) {
        this.consumerNodeId = consumerNodeId;
        this.curator = curator;
        this.subscriptionsCache = subscriptionsCache;
        this.pathSerializer = pathSerializer;
        this.cache = new HierarchicalCache(curator, (ExecutorService)Executors.newSingleThreadScheduledExecutor(), path, 2, Collections.emptyList());
        this.cache.registerCallback(1, e -> {
            SubscriptionAssignment assignment = pathSerializer.deserialize(e.getData().getPath());
            switch (e.getType()) {
                case CHILD_ADDED: {
                    this.assignments.add(assignment);
                    break;
                }
                case CHILD_REMOVED: {
                    this.assignments.remove(assignment);
                    this.removeSubscriptionEntryIfEmpty(assignment.getSubscriptionName());
                }
            }
        });
    }

    public void start() throws Exception {
        this.cache.start();
    }

    public void stop() throws Exception {
        this.cache.stop();
    }

    public void registerAssignementCallback(SubscriptionAssignmentAware callback) {
        this.cache.registerCallback(1, e -> {
            SubscriptionAssignment assignment = this.pathSerializer.deserialize(e.getData().getPath());
            if (this.consumerNodeId.equals(assignment.getConsumerNodeId())) {
                switch (e.getType()) {
                    case CHILD_ADDED: {
                        callback.onSubscriptionAssigned(this.subscriptionsCache.getSubscription(assignment.getSubscriptionName()));
                        break;
                    }
                    case CHILD_REMOVED: {
                        callback.onAssignmentRemoved(assignment.getSubscriptionName());
                    }
                }
            }
        });
    }

    public boolean isAssignedTo(String nodeId, SubscriptionName subscription) {
        return this.assignments.stream().anyMatch(a -> a.getSubscriptionName().equals((Object)subscription) && a.getConsumerNodeId().equals(nodeId));
    }

    public SubscriptionAssignmentView createSnapshot() {
        HashMap<SubscriptionName, Set<SubscriptionAssignment>> snapshot = new HashMap<SubscriptionName, Set<SubscriptionAssignment>>();
        for (SubscriptionAssignment assignment : this.assignments) {
            snapshot.compute(assignment.getSubscriptionName(), (k, v) -> {
                v = v == null ? new HashSet() : v;
                v.add(assignment);
                return v;
            });
        }
        return new SubscriptionAssignmentView(snapshot);
    }

    private void removeSubscriptionEntryIfEmpty(SubscriptionName subscriptionName) {
        this.askCuratorPolitely(() -> {
            if (((List)this.curator.getChildren().forPath(this.pathSerializer.serialize(subscriptionName))).isEmpty()) {
                this.curator.delete().guaranteed().forPath(this.pathSerializer.serialize(subscriptionName));
            }
        });
    }

    public void dropAssignment(SubscriptionAssignment assignment) {
        this.askCuratorPolitely(() -> {
            Void cfr_ignored_0 = (Void)this.curator.delete().guaranteed().forPath(this.pathSerializer.serialize(assignment.getSubscriptionName(), assignment.getConsumerNodeId()));
        });
    }

    public void addPersistentAssignment(SubscriptionAssignment assignment) {
        this.addAssignment(assignment, CreateMode.PERSISTENT);
    }

    public void addEphemeralAssignment(SubscriptionAssignment assignment) {
        this.addAssignment(assignment, CreateMode.EPHEMERAL);
    }

    private void addAssignment(SubscriptionAssignment assignment, CreateMode createMode) {
        this.askCuratorPolitely(() -> {
            String cfr_ignored_0 = (String)((ACLBackgroundPathAndBytesable)this.curator.create().creatingParentsIfNeeded().withMode(createMode)).forPath(this.pathSerializer.serialize(assignment.getSubscriptionName(), assignment.getConsumerNodeId()));
        });
    }

    private void askCuratorPolitely(CuratorTask task) {
        try {
            task.run();
        }
        catch (KeeperException.NoNodeException | KeeperException.NodeExistsException throwable) {
        }
        catch (Exception ex) {
            throw new InternalProcessingException((Throwable)ex);
        }
    }

    static interface CuratorTask {
        public void run() throws Exception;
    }
}

