/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.rate.maxrate;

import java.time.Clock;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.allegro.tech.hermes.api.Subscription;
import pl.allegro.tech.hermes.api.SubscriptionName;
import pl.allegro.tech.hermes.common.metric.HermesMetrics;
import pl.allegro.tech.hermes.consumers.consumer.rate.maxrate.ConsumerRateInfo;
import pl.allegro.tech.hermes.consumers.consumer.rate.maxrate.MaxRate;
import pl.allegro.tech.hermes.consumers.consumer.rate.maxrate.MaxRateBalancer;
import pl.allegro.tech.hermes.consumers.consumer.rate.maxrate.MaxRateRegistry;
import pl.allegro.tech.hermes.consumers.consumer.rate.maxrate.SubscriptionConsumersCache;
import pl.allegro.tech.hermes.consumers.subscription.cache.SubscriptionsCache;

class MaxRateCalculator {
    private static final Logger logger = LoggerFactory.getLogger(MaxRateCalculator.class);
    private final SubscriptionConsumersCache subscriptionConsumersCache;
    private final SubscriptionsCache subscriptionsCache;
    private final MaxRateBalancer balancer;
    private final MaxRateRegistry maxRateRegistry;
    private final HermesMetrics metrics;
    private final Clock clock;
    private volatile long lastUpdateDurationMillis = 0L;

    MaxRateCalculator(SubscriptionConsumersCache subscriptionConsumersCache, SubscriptionsCache subscriptionsCache, MaxRateBalancer balancer, MaxRateRegistry maxRateRegistry, HermesMetrics metrics, Clock clock) {
        this.subscriptionConsumersCache = subscriptionConsumersCache;
        this.subscriptionsCache = subscriptionsCache;
        this.balancer = balancer;
        this.maxRateRegistry = maxRateRegistry;
        this.metrics = metrics;
        this.clock = clock;
        metrics.registerGauge("consumers-rate.max-rate.coordinator.duration", () -> this.lastUpdateDurationMillis);
    }

    void calculate() {
        try {
            if (!this.subscriptionConsumersCache.isStarted()) {
                return;
            }
            logger.info("Max rate calculation started");
            long start = this.clock.millis();
            Map<SubscriptionName, Set<String>> subscriptionConsumers = this.subscriptionConsumersCache.getSubscriptionsConsumers();
            subscriptionConsumers.entrySet().forEach(entry -> {
                try {
                    Subscription subscription = this.subscriptionsCache.getSubscription((SubscriptionName)entry.getKey());
                    if (!subscription.isBatchSubscription()) {
                        Set consumerIds = (Set)entry.getValue();
                        Set<ConsumerRateInfo> rateInfos = this.maxRateRegistry.ensureCorrectAssignments(subscription.getQualifiedName(), consumerIds);
                        Optional<Map<String, MaxRate>> newRates = this.balancer.balance(subscription.getSerialSubscriptionPolicy().getRate().intValue(), rateInfos);
                        newRates.ifPresent(rates -> {
                            logger.info("Calculated new max rates for {}: {}", (Object)subscription.getQualifiedName(), rates);
                            this.maxRateRegistry.update(subscription.getQualifiedName(), (Map<String, MaxRate>)rates);
                        });
                    }
                }
                catch (Exception e) {
                    logger.error("Problem calculating max rates for subscription {}", entry.getKey(), (Object)e);
                }
            });
            this.lastUpdateDurationMillis = this.clock.millis() - start;
            logger.info("Max rate calculation done in {} ms", (Object)this.lastUpdateDurationMillis);
        }
        catch (Exception e) {
            logger.error("Problem calculating max rate", (Throwable)e);
        }
    }
}

