/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.rate.maxrate;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.time.Clock;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.leader.LeaderLatch;
import org.apache.curator.framework.recipes.leader.LeaderLatchListener;
import pl.allegro.tech.hermes.common.config.ConfigFactory;
import pl.allegro.tech.hermes.common.config.Configs;
import pl.allegro.tech.hermes.common.exception.InternalProcessingException;
import pl.allegro.tech.hermes.common.metric.HermesMetrics;
import pl.allegro.tech.hermes.consumers.consumer.rate.maxrate.MaxRateBalancer;
import pl.allegro.tech.hermes.consumers.consumer.rate.maxrate.MaxRateCalculator;
import pl.allegro.tech.hermes.consumers.consumer.rate.maxrate.MaxRateRegistry;
import pl.allegro.tech.hermes.consumers.consumer.rate.maxrate.SubscriptionConsumersCache;
import pl.allegro.tech.hermes.consumers.subscription.cache.SubscriptionsCache;

class MaxRateCalculatorJob
implements LeaderLatchListener,
Runnable {
    private final int intervalSeconds;
    private final ScheduledExecutorService executorService;
    private final CuratorFramework curator;
    private final LeaderLatch leaderLatch;
    private final MaxRateCalculator maxRateCalculator;
    private ScheduledFuture job;

    MaxRateCalculatorJob(CuratorFramework curator, ConfigFactory configFactory, SubscriptionConsumersCache subscriptionConsumersCache, MaxRateBalancer balancer, MaxRateRegistry maxRateRegistry, String leaderPath, SubscriptionsCache subscriptionsCache, HermesMetrics metrics, Clock clock) {
        String consumerId = configFactory.getStringProperty(Configs.CONSUMER_WORKLOAD_NODE_ID);
        this.curator = curator;
        this.intervalSeconds = configFactory.getIntProperty(Configs.CONSUMER_MAXRATE_BALANCE_INTERVAL_SECONDS);
        this.executorService = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("max-rate-calculator-%d").build());
        this.maxRateCalculator = new MaxRateCalculator(subscriptionConsumersCache, subscriptionsCache, balancer, maxRateRegistry, metrics, clock);
        this.leaderLatch = new LeaderLatch(curator, leaderPath, consumerId);
    }

    public void start() {
        try {
            this.leaderLatch.start();
            this.leaderLatch.addListener((LeaderLatchListener)this);
        }
        catch (Exception e) {
            throw new InternalProcessingException((Throwable)e);
        }
    }

    public void stop() throws InterruptedException {
        try {
            this.leaderLatch.removeListener((LeaderLatchListener)this);
            this.leaderLatch.close();
        }
        catch (Exception e) {
            throw new InternalProcessingException((Throwable)e);
        }
        if (this.job != null) {
            this.job.cancel(false);
        }
        this.executorService.shutdown();
        this.executorService.awaitTermination(1L, TimeUnit.MINUTES);
    }

    private boolean hasLeadership() {
        return this.curator.getZookeeperClient().isConnected() && this.leaderLatch.hasLeadership();
    }

    @Override
    public void run() {
        if (this.hasLeadership()) {
            this.maxRateCalculator.calculate();
        }
    }

    public void isLeader() {
        this.job = this.executorService.scheduleAtFixedRate(this, this.intervalSeconds, this.intervalSeconds, TimeUnit.SECONDS);
    }

    public void notLeader() {
        this.job.cancel(false);
    }
}

