/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.rate.maxrate;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.time.Clock;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.apache.curator.framework.CuratorFramework;
import pl.allegro.tech.hermes.common.config.ConfigFactory;
import pl.allegro.tech.hermes.common.config.Configs;
import pl.allegro.tech.hermes.common.metric.HermesMetrics;
import pl.allegro.tech.hermes.consumers.consumer.rate.maxrate.MaxRateBalancer;
import pl.allegro.tech.hermes.consumers.consumer.rate.maxrate.MaxRateCalculatorJob;
import pl.allegro.tech.hermes.consumers.consumer.rate.maxrate.MaxRateRegistry;
import pl.allegro.tech.hermes.consumers.consumer.rate.maxrate.NegotiatedMaxRateProvider;
import pl.allegro.tech.hermes.consumers.consumer.rate.maxrate.SubscriptionConsumersCache;
import pl.allegro.tech.hermes.consumers.subscription.cache.SubscriptionsCache;
import pl.allegro.tech.hermes.infrastructure.zookeeper.ZookeeperPaths;

public class MaxRateSupervisor
implements Runnable {
    private final Set<NegotiatedMaxRateProvider> providers = Collections.newSetFromMap(new ConcurrentHashMap());
    private final ConfigFactory configFactory;
    private final ScheduledExecutorService selfUpdateExecutor;
    private final MaxRateCalculatorJob calculatorJob;
    private final MaxRateRegistry maxRateRegistry;
    private ScheduledFuture<?> updateJob;

    @Inject
    public MaxRateSupervisor(ConfigFactory configFactory, CuratorFramework curator, SubscriptionConsumersCache subscriptionConsumersCache, MaxRateRegistry maxRateRegistry, SubscriptionsCache subscriptionsCache, ZookeeperPaths zookeeperPaths, HermesMetrics metrics, Clock clock) {
        this.configFactory = configFactory;
        this.maxRateRegistry = maxRateRegistry;
        this.selfUpdateExecutor = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("max-rate-provider-%d").build());
        MaxRateBalancer balancer = new MaxRateBalancer(configFactory.getDoubleProperty(Configs.CONSUMER_MAXRATE_BUSY_TOLERANCE), configFactory.getDoubleProperty(Configs.CONSUMER_MAXRATE_MIN_MAX_RATE), configFactory.getDoubleProperty(Configs.CONSUMER_MAXRATE_MIN_ALLOWED_CHANGE_PERCENT));
        this.calculatorJob = new MaxRateCalculatorJob(curator, configFactory, subscriptionConsumersCache, balancer, maxRateRegistry, zookeeperPaths.maxRateLeaderPath(), subscriptionsCache, metrics, clock);
    }

    public void start() throws Exception {
        this.maxRateRegistry.start();
        this.calculatorJob.start();
        this.updateJob = this.startSelfUpdate();
    }

    public void stop() throws Exception {
        this.maxRateRegistry.stop();
        this.calculatorJob.stop();
        if (this.updateJob != null) {
            this.updateJob.cancel(false);
        }
        this.selfUpdateExecutor.shutdown();
        this.selfUpdateExecutor.awaitTermination(10L, TimeUnit.SECONDS);
    }

    private ScheduledFuture<?> startSelfUpdate() {
        int selfUpdateInterval = this.configFactory.getIntProperty(Configs.CONSUMER_MAXRATE_UPDATE_INTERVAL_SECONDS);
        return this.selfUpdateExecutor.scheduleAtFixedRate(this, 0L, selfUpdateInterval, TimeUnit.SECONDS);
    }

    @Override
    public void run() {
        this.providers.forEach(NegotiatedMaxRateProvider::tickForHistory);
    }

    public void register(NegotiatedMaxRateProvider maxRateProvider) {
        this.providers.add(maxRateProvider);
    }

    public void unregister(NegotiatedMaxRateProvider maxRateProvider) {
        this.providers.remove(maxRateProvider);
    }
}

